/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.referencing;

import javax.measure.Unit;
import org.apache.sis.internal.referencing.AxisDirections;
import org.apache.sis.internal.referencing.CoordinateOperations;
import org.apache.sis.measure.Units;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.referencing.operation.transform.WraparoundTransform;
import org.apache.sis.util.collection.BackingStoreException;
import org.opengis.geometry.DirectPosition;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.cs.RangeMeaning;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

public final class WraparoundApplicator {
    private final DirectPosition sourceMedian;
    private final DirectPosition targetMedian;
    private final CoordinateSystem targetCS;

    public WraparoundApplicator(DirectPosition directPosition, DirectPosition directPosition2, CoordinateSystem coordinateSystem) {
        this.sourceMedian = directPosition;
        this.targetMedian = directPosition2;
        this.targetCS = coordinateSystem;
    }

    public static MathTransform forTargetCRS(CoordinateOperation coordinateOperation) throws TransformException {
        WraparoundApplicator wraparoundApplicator = new WraparoundApplicator(null, null, coordinateOperation.getTargetCRS().getCoordinateSystem());
        MathTransform mathTransform = coordinateOperation.getMathTransform();
        for (int n : CoordinateOperations.wrapAroundChanges(coordinateOperation)) {
            mathTransform = wraparoundApplicator.concatenate(mathTransform, n);
        }
        return mathTransform;
    }

    public MathTransform forDomainOfUse(MathTransform mathTransform) throws TransformException {
        int n = this.targetCS.getDimension();
        for (int i = 0; i < n; ++i) {
            mathTransform = this.concatenate(mathTransform, i);
        }
        return mathTransform;
    }

    private MathTransform concatenate(MathTransform mathTransform, int n) throws TransformException {
        double d;
        CoordinateSystemAxis coordinateSystemAxis;
        double d2 = WraparoundApplicator.range(this.targetCS, n);
        if (!(d2 > 0.0) || d2 == Double.POSITIVE_INFINITY) {
            return mathTransform;
        }
        if (this.targetMedian == null) {
            coordinateSystemAxis = this.targetCS.getAxis(n);
            d = (coordinateSystemAxis.getMinimumValue() + coordinateSystemAxis.getMaximumValue()) / 2.0;
        } else {
            try {
                d = this.targetMedian.getOrdinate(n);
            }
            catch (BackingStoreException backingStoreException) {
                throw backingStoreException.unwrapOrRethrow(TransformException.class);
            }
        }
        if (!Double.isFinite(d)) {
            if (this.targetMedian != null) {
                return mathTransform;
            }
            d = 0.0;
        }
        coordinateSystemAxis = WraparoundTransform.create(mathTransform.getTargetDimensions(), n, d2, this.sourceMedian == null ? Double.NaN : this.sourceMedian.getOrdinate(n), d);
        return MathTransforms.concatenate(mathTransform, (MathTransform)coordinateSystemAxis);
    }

    public static double range(CoordinateSystem coordinateSystem, int n) {
        CoordinateSystemAxis coordinateSystemAxis = coordinateSystem.getAxis(n);
        if (coordinateSystemAxis != null && RangeMeaning.WRAPAROUND.equals((Object)coordinateSystemAxis.getRangeMeaning())) {
            double d = coordinateSystemAxis.getMaximumValue() - coordinateSystemAxis.getMinimumValue();
            if (d > 0.0 && d != Double.POSITIVE_INFINITY) {
                return d;
            }
            AxisDirection axisDirection = AxisDirections.absolute(coordinateSystemAxis.getDirection());
            if (AxisDirection.EAST.equals((Object)axisDirection) && coordinateSystem instanceof EllipsoidalCS) {
                d = 360.0;
                Unit unit = coordinateSystemAxis.getUnit();
                if (unit != null) {
                    d = Units.DEGREE.getConverterTo(Units.ensureAngular(unit)).convert(d);
                }
                return d;
            }
        }
        return Double.NaN;
    }
}

