/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.util.bundles;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.jar.Manifest;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class BundleUtils {
    public static File fixBundleWithUpdateLocation(InputStream is, String uri) throws IOException {
        File file = Files.createTempFile("update-", ".jar", new FileAttribute[0]).toFile();
        try (ZipInputStream zis = new ZipInputStream(is);
             ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(file));){
            ZipEntry entry;
            byte[] buf = new byte[8192];
            zos.setLevel(0);
            while ((entry = zis.getNextEntry()) != null) {
                int n;
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                while (-1 != (n = zis.read(buf))) {
                    baos.write(buf, 0, n);
                }
                if (entry.getName().equals("META-INF/MANIFEST.MF")) {
                    Manifest man = new Manifest(new ByteArrayInputStream(baos.toByteArray()));
                    if (man.getMainAttributes().getValue("Bundle-UpdateLocation") == null) {
                        man.getMainAttributes().putValue("Bundle-UpdateLocation", uri);
                    }
                    baos.reset();
                    man.write(baos);
                }
                byte[] data = baos.toByteArray();
                CRC32 crc = new CRC32();
                crc.update(data);
                entry = new ZipEntry(entry.getName());
                entry.setSize(data.length);
                entry.setCrc(crc.getValue());
                zos.putNextEntry(entry);
                zos.write(data);
                zis.closeEntry();
                zos.closeEntry();
            }
        }
        return file;
    }
}

