/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.doc.internal;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.juneau.doc.internal.IOUtils;

public class ConfigPropsGenerator {
    private static final Map<String, PropertyInfo> ENTRIES = new TreeMap<String, PropertyInfo>();
    private static final String PROPERTY = "Configuration property:";
    private static final String ID = "<li><b>ID:</b>";
    private static final String NAME = "<li><b>Name:</b>";
    private static final String DATA_TYPE = "<li><b>Data type:</b>";
    private static final String SYSTEM_PROPERTY = "<li><b>System property:</b>";
    private static final String ENVIRONMENT_VARIABLE = "<li><b>Environment variable:</b>";
    private static final String DEFAULT = "<li><b>Default:</b>";
    private static final String METHODS = "<li><b>Methods:</b>";
    private static final String ANNOTATIONS = "<li><b>Annotations:</b>";

    public static void main(String[] args) {
        ConfigPropsGenerator.run(System.out);
    }

    public static void run(PrintStream out) {
        try {
            out.println("<table class='styled w1000'>");
            out.println("\t<tr>");
            out.println("\t\t<th>Context</th><th>ID</th><th style='min-width:250px'>Description</th><th>Data type</th>");
            out.println("\t</tr>");
            String[] stringArray = "juneau-core/juneau-config,juneau-core/juneau-dto,juneau-core/juneau-marshall,juneau-core/juneau-marshall-rdf,juneau-rest/juneau-rest-client,juneau-rest/juneau-rest-server".split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                ConfigPropsGenerator.process(new File("../" + s + "/src/main/java"));
                ++n2;
            }
            String processing = "xxx";
            for (PropertyInfo pi : ENTRIES.values()) {
                if (pi.file.equals(processing)) {
                    pi.context = "";
                }
                processing = pi.file;
            }
            ENTRIES.values().stream().forEach(x -> x.out(out));
            out.println("</table>");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String run() {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(os);
        ConfigPropsGenerator.run(ps);
        ps.flush();
        try {
            return os.toString("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return e.getLocalizedMessage();
        }
    }

    private static void process(File f) throws Exception {
        File[] fileArray = f.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            String contents;
            File f2 = fileArray[n2];
            if (f2.isDirectory()) {
                ConfigPropsGenerator.process(f2);
            } else if (f2.isFile() && f2.getName().endsWith(".java") && (contents = IOUtils.read(f2)).contains("<h5 class='section'>Property:</h5>")) {
                List<String> javadocs = IOUtils.findJavadocs(contents);
                for (String jd : javadocs) {
                    if (!jd.contains("<h5 class='section'>Property:</h5>")) continue;
                    PropertyInfo pi = new PropertyInfo(f2);
                    int x = 0;
                    String[] stringArray = jd.split("\n");
                    int n3 = stringArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String line = stringArray[n4];
                        if (line.contains(PROPERTY)) {
                            pi.description(line.substring(line.indexOf(PROPERTY) + PROPERTY.length()).trim());
                        } else if (line.contains(ID)) {
                            pi.id(line.substring(line.indexOf(ID) + ID.length()).trim());
                            x = 1;
                        } else if (line.contains(NAME)) {
                            pi.name(line.substring(line.indexOf(NAME) + NAME.length()).trim());
                            x = 2;
                        } else if (line.contains(DATA_TYPE)) {
                            pi.dataType(line.substring(line.indexOf(DATA_TYPE) + DATA_TYPE.length()).trim());
                            x = 3;
                        } else if (line.contains(SYSTEM_PROPERTY)) {
                            pi.systemProperty(line.substring(line.indexOf(SYSTEM_PROPERTY) + SYSTEM_PROPERTY.length()).trim());
                            x = 4;
                        } else if (line.contains(ENVIRONMENT_VARIABLE)) {
                            pi.envVar(line.substring(line.indexOf(ENVIRONMENT_VARIABLE) + ENVIRONMENT_VARIABLE.length()).trim());
                            x = 5;
                        } else if (line.contains(DEFAULT)) {
                            pi.def(line.substring(line.indexOf(DEFAULT) + DEFAULT.length()).trim());
                            x = 6;
                        } else if (line.contains(METHODS)) {
                            pi.def(line.substring(line.indexOf(METHODS) + METHODS.length()).trim());
                            x = 7;
                        } else if (line.contains(ANNOTATIONS)) {
                            pi.def(line.substring(line.indexOf(ANNOTATIONS) + ANNOTATIONS.length()).trim());
                            x = 8;
                        } else if (line.contains("* </ul>") || line.contains("<li><b>")) {
                            x = 0;
                        } else if (x != 0) {
                            if (x == 1) {
                                pi.id(line.substring(line.indexOf(42) + 1).trim());
                            } else if (x == 2) {
                                pi.name(line.substring(line.indexOf(42) + 1).trim());
                            } else if (x == 3) {
                                pi.dataType(line.substring(line.indexOf(42) + 1).trim());
                            } else if (x == 4) {
                                pi.systemProperty(line.substring(line.indexOf(42) + 1).trim());
                            } else if (x == 5) {
                                pi.envVar(line.substring(line.indexOf(42) + 1).trim());
                            } else if (x == 6) {
                                pi.def(line.substring(line.indexOf(42) + 1).trim());
                            } else if (x == 7) {
                                pi.methods(line.substring(line.indexOf(42) + 1).trim());
                            } else if (x == 8) {
                                pi.annotations(line.substring(line.indexOf(42) + 1).trim());
                            }
                        }
                        ++n4;
                    }
                    ENTRIES.put(String.valueOf(f2.getName()) + "/" + pi.name, pi);
                }
            }
            ++n2;
        }
    }

    static class PropertyInfo {
        String file = "";
        String context = "";
        String id = "";
        String name = "";
        String description = "";
        String dataType = "";
        String systemProperty = "";
        String envVar = "";
        String def = "";
        String methods = "";
        String annotations = "";

        public PropertyInfo(File f) {
            String path = f.getAbsolutePath();
            path = path.substring(path.indexOf("org/apache")).replace(".java", "").replace('/', '.');
            this.context = "{@link " + path + "}";
            this.file = f.getName();
        }

        public void id(String s) {
            this.id = String.valueOf(this.id) + s;
        }

        public void name(String s) {
            this.name = String.valueOf(this.name) + s;
        }

        public void description(String s) {
            this.description = String.valueOf(this.description) + s;
        }

        public void dataType(String s) {
            this.dataType = String.valueOf(this.dataType) + s;
        }

        public void systemProperty(String s) {
            this.systemProperty = String.valueOf(this.systemProperty) + s;
        }

        public void envVar(String s) {
            this.envVar = String.valueOf(this.envVar) + s;
        }

        public void def(String s) {
            this.def = String.valueOf(this.def) + s;
        }

        public void methods(String s) {
            this.methods = String.valueOf(this.methods) + s;
        }

        public void annotations(String s) {
            this.annotations = String.valueOf(this.annotations) + s;
        }

        public void out(PrintStream out) {
            out.println("\t<tr>");
            out.println("\t\t<td>" + this.context + "</td>");
            out.println("\t\t<td>" + this.id + "</td>");
            out.println("\t\t<td>" + this.description + "</td>");
            out.println("\t\t<td style='max-width:250px;overflow:hidden'>" + this.dataType + "</td>");
            out.println("\t</tr>");
        }
    }
}

