/*
 * Decompiled with CFR 0.152.
 */
package org.roaringbitmap.buffer;

import org.roaringbitmap.PeekableCharIterator;
import org.roaringbitmap.PeekableIntIterator;
import org.roaringbitmap.buffer.BufferUtil;
import org.roaringbitmap.buffer.ImmutableRoaringBitmap;
import org.roaringbitmap.buffer.MappeableArrayContainer;
import org.roaringbitmap.buffer.MappeableArrayContainerCharIterator;
import org.roaringbitmap.buffer.MappeableBitmapContainer;
import org.roaringbitmap.buffer.MappeableBitmapContainerCharIterator;
import org.roaringbitmap.buffer.MappeableContainer;
import org.roaringbitmap.buffer.MappeableRunContainer;
import org.roaringbitmap.buffer.MappeableRunContainerCharIterator;

public class BufferIntIteratorFlyweight
implements PeekableIntIterator {
    private int hs;
    private PeekableCharIterator iter;
    private MappeableArrayContainerCharIterator arrIter = new MappeableArrayContainerCharIterator();
    private MappeableBitmapContainerCharIterator bitmapIter = new MappeableBitmapContainerCharIterator();
    private MappeableRunContainerCharIterator runIter = new MappeableRunContainerCharIterator();
    private int pos;
    private ImmutableRoaringBitmap roaringBitmap = null;

    public BufferIntIteratorFlyweight() {
    }

    public BufferIntIteratorFlyweight(ImmutableRoaringBitmap r) {
        this.wrap(r);
    }

    @Override
    public PeekableIntIterator clone() {
        try {
            BufferIntIteratorFlyweight x = (BufferIntIteratorFlyweight)super.clone();
            if (this.iter != null) {
                x.iter = this.iter.clone();
            }
            return x;
        }
        catch (CloneNotSupportedException e2) {
            return null;
        }
    }

    @Override
    public boolean hasNext() {
        return this.pos < this.roaringBitmap.highLowContainer.size();
    }

    @Override
    public int next() {
        int x = this.iter.nextAsInt() | this.hs;
        if (!this.iter.hasNext()) {
            ++this.pos;
            this.nextContainer();
        }
        return x;
    }

    private void nextContainer() {
        if (this.pos < this.roaringBitmap.highLowContainer.size()) {
            MappeableContainer container2 = this.roaringBitmap.highLowContainer.getContainerAtIndex(this.pos);
            if (container2 instanceof MappeableBitmapContainer) {
                this.bitmapIter.wrap((MappeableBitmapContainer)container2);
                this.iter = this.bitmapIter;
            } else if (container2 instanceof MappeableRunContainer) {
                this.runIter.wrap((MappeableRunContainer)container2);
                this.iter = this.runIter;
            } else {
                this.arrIter.wrap((MappeableArrayContainer)container2);
                this.iter = this.arrIter;
            }
            this.hs = this.roaringBitmap.highLowContainer.getKeyAtIndex(this.pos) << 16;
        }
    }

    public void wrap(ImmutableRoaringBitmap r) {
        this.hs = 0;
        this.pos = 0;
        this.roaringBitmap = r;
        this.nextContainer();
    }

    @Override
    public void advanceIfNeeded(int minval) {
        while (this.hasNext() && this.hs >>> 16 < minval >>> 16) {
            ++this.pos;
            this.nextContainer();
        }
        if (this.hasNext() && this.hs >>> 16 == minval >>> 16) {
            this.iter.advanceIfNeeded(BufferUtil.lowbits(minval));
            if (!this.iter.hasNext()) {
                ++this.pos;
                this.nextContainer();
            }
        }
    }

    @Override
    public int peekNext() {
        return this.iter.peekNext() | this.hs;
    }
}

