/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.util.iso;

import java.util.Iterator;
import java.util.Set;
import org.apache.jena.graph.Node;
import org.apache.jena.riot.out.NodeFmtLib;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.exec.RowSet;
import org.apache.jena.sparql.exec.RowSetRewindable;
import org.apache.jena.sparql.util.EqualityTest;

class IsoLib {
    static final boolean DEBUG = false;
    static Mappable mappableBlankNodes = (n1, n2) -> n1.isBlank() && n2.isBlank();
    static Mappable mappableVariables = (n1, n2) -> n1.isVariable() && n2.isVariable();
    static Mappable mappableBlankNodesVariables = (n1, n2) -> {
        if (n1.isBlank() && n2.isBlank()) {
            return true;
        }
        return n1.isVariable() && n2.isVariable();
    };
    static Mappable mappableNoMap = (n1, n2) -> false;

    IsoLib() {
    }

    static boolean compareHeader(RowSet rs1, RowSet rs2) {
        if (rs1 == null && rs2 == null) {
            return true;
        }
        if (rs1 == null) {
            return false;
        }
        if (rs2 == null) {
            return false;
        }
        Set<Var> names1 = Set.copyOf(rs1.getResultVars());
        Set<Var> names2 = Set.copyOf(rs2.getResultVars());
        return names1.equals(names2);
    }

    static RowSetRewindable print(RowSet rs) {
        RowSetRewindable rsw = rs.rewindable();
        rsw.forEach(binding -> {
            String x = IsoLib.str(binding);
            System.out.print("  ");
            System.out.print(x);
            System.out.println();
        });
        rsw.reset();
        return rsw;
    }

    static String str(Binding binding) {
        StringBuffer sbuff = new StringBuffer();
        binding.forEach((var, node) -> {
            String tmp = NodeFmtLib.strNT(node);
            sbuff.append("( ?" + var.getVarName() + " = " + tmp + " )");
        });
        return sbuff.toString();
    }

    static boolean equal(Binding bind1, Binding bind2, EqualityTest test) {
        if (bind1 == bind2) {
            return true;
        }
        if (bind1.size() != bind2.size()) {
            return false;
        }
        return IsoLib.containedIn(bind1, bind2, test);
    }

    private static boolean containedIn(Binding bind1, Binding bind2, EqualityTest test) {
        Iterator<Var> iter1 = bind1.vars();
        while (iter1.hasNext()) {
            Var v = iter1.next();
            Node n1 = bind1.get(v);
            Node n2 = bind2.get(v);
            if (n2 == null) {
                return false;
            }
            if (test.equal(n1, n2)) continue;
            return false;
        }
        return true;
    }

    @FunctionalInterface
    static interface Mappable {
        public boolean mappable(Node var1, Node var2);
    }
}

