/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.reasoner.rulesys.builtins;

import org.apache.jena.graph.Node;
import org.apache.jena.reasoner.rulesys.BindingEnvironment;
import org.apache.jena.reasoner.rulesys.RuleContext;
import org.apache.jena.reasoner.rulesys.Util;
import org.apache.jena.reasoner.rulesys.builtins.BaseBuiltin;
import org.apache.jena.vocabulary.RDF;

public class ListEntry
extends BaseBuiltin {
    @Override
    public String getName() {
        return "listEntry";
    }

    @Override
    public int getArgLength() {
        return 3;
    }

    @Override
    public boolean bodyCall(Node[] args, int length, RuleContext context2) {
        this.checkArgs(length, context2);
        BindingEnvironment env = context2.getEnv();
        Node list = this.getArg(0, args, context2);
        Node index = this.getArg(1, args, context2);
        if (!Util.isNumeric(index)) {
            return false;
        }
        Node elt = ListEntry.getEntry(list, Util.getIntValue(index), context2);
        if (elt == null) {
            return false;
        }
        env.bind(args[2], elt);
        return true;
    }

    protected static Node getEntry(Node list, int i, RuleContext context2) {
        int count = 0;
        Node node = list;
        while (node != null && !node.equals(RDF.Nodes.nil)) {
            if (count == i) {
                return Util.getPropValue(node, RDF.Nodes.first, context2);
            }
            node = Util.getPropValue(node, RDF.Nodes.rest, context2);
            ++count;
        }
        return null;
    }
}

