/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.validation.json;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.HashMap;
import java.util.Map;
import org.apache.jena.atlas.logging.Log;
import org.slf4j.Logger;

public class ValidationAction {
    public final boolean verbose;
    public final long id;
    public final Logger log;
    private boolean startTimeIsSet = false;
    private boolean finishTimeIsSet = false;
    private long startTime = -2L;
    private long finishTime = -2L;
    public int statusCode = -1;
    public String message = null;
    public int contentLength = -1;
    public String contentType = null;
    public Map<String, String> headers = new HashMap<String, String>();
    public HttpServletRequest request;
    public HttpServletResponse response;

    public ValidationAction(long id, Logger log2, HttpServletRequest request, HttpServletResponse response, boolean verbose) {
        this.id = id;
        this.log = log2;
        this.request = request;
        this.response = response;
        this.verbose = false;
    }

    public void minimize() {
        this.request = null;
        this.response = null;
    }

    public void setStartTime() {
        if (this.startTimeIsSet) {
            Log.warn(this, "Start time reset");
        }
        this.startTimeIsSet = true;
        this.startTime = System.nanoTime();
    }

    public void setFinishTime() {
        if (this.finishTimeIsSet) {
            Log.warn(this, "Finish time reset");
        }
        this.finishTimeIsSet = true;
        this.finishTime = System.nanoTime();
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public HttpServletResponse getResponse() {
        return this.response;
    }

    public long getTime() {
        if (!this.startTimeIsSet) {
            Log.warn(this, "Start time not set");
        }
        if (!this.finishTimeIsSet) {
            Log.warn(this, "Finish time not set");
        }
        return (this.finishTime - this.startTime) / 1000000L;
    }
}

