/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.server;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import org.apache.commons.collections4.ListValuedMap;
import org.apache.commons.collections4.MultiMapUtils;
import org.apache.commons.collections4.MultiValuedMap;
import org.apache.jena.fuseki.Fuseki;
import org.apache.jena.fuseki.FusekiException;
import org.apache.jena.fuseki.auth.AuthPolicy;
import org.apache.jena.fuseki.build.FusekiConfig;
import org.apache.jena.fuseki.server.CounterName;
import org.apache.jena.fuseki.server.CounterSet;
import org.apache.jena.fuseki.server.DataAccessPoint;
import org.apache.jena.fuseki.server.DataServiceStatus;
import org.apache.jena.fuseki.server.DispatchFunction;
import org.apache.jena.fuseki.server.Endpoint;
import org.apache.jena.fuseki.server.EndpointSet;
import org.apache.jena.fuseki.server.Operation;
import org.apache.jena.fuseki.server.OperationRegistry;
import org.apache.jena.query.TxnType;
import org.apache.jena.riot.out.NodeFmtLib;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DatasetGraphWrapper;
import org.apache.jena.tdb1.sys.TDBInternal;

public class DataService {
    private DatasetGraph dataset;
    private final Map<String, EndpointSet> endpoints;
    private final ListValuedMap<Operation, Endpoint> operationsMap;
    private final AuthPolicy authPolicy;
    private List<DataAccessPoint> dataAccessPoints = new ArrayList<DataAccessPoint>(1);
    private List<Consumer<DataService>> shutdownHandlers = new ArrayList<Consumer<DataService>>(5);
    private volatile DataServiceStatus state = DataServiceStatus.UNINITIALIZED;
    private final CounterSet counters = new CounterSet();
    private final AtomicBoolean offlineInProgress = new AtomicBoolean(false);
    private final AtomicBoolean acceptingRequests = new AtomicBoolean(true);
    private DispatchFunction plainOperationChooser;
    public AtomicLong activeTxn = new AtomicLong(0L);
    public AtomicLong totalTxn = new AtomicLong(0L);

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(DatasetGraph dsg) {
        return DataService.newBuilder().dataset(dsg);
    }

    public static Builder newBuilder(DataService dSrv) {
        return new Builder(dSrv.dataset, dSrv.endpoints, dSrv.operationsMap, dSrv.plainOperationChooser, dSrv.authPolicy);
    }

    private DataService(DatasetGraph dataset, Map<String, EndpointSet> endpoints, MultiValuedMap<Operation, Endpoint> operationsMap, DispatchFunction plainOperationChooser, AuthPolicy authPolicy) {
        this.dataset = dataset;
        this.endpoints = Map.copyOf(endpoints);
        this.operationsMap = MultiMapUtils.newListValuedHashMap();
        this.operationsMap.putAll(operationsMap);
        this.plainOperationChooser = plainOperationChooser;
        this.authPolicy = authPolicy;
        this.counters.add(CounterName.Requests);
        this.counters.add(CounterName.RequestsGood);
        this.counters.add(CounterName.RequestsBad);
    }

    void noteDataAccessPoint(DataAccessPoint dap) {
        this.dataAccessPoints.add(dap);
    }

    private String label() {
        StringJoiner sj = new StringJoiner(", ", "[", "]");
        this.dataAccessPoints.stream().map(DataAccessPoint::getName).filter(x -> !x.isEmpty()).forEach(sj::add);
        return sj.toString();
    }

    public DatasetGraph getDataset() {
        return this.dataset;
    }

    public EndpointSet getEndpointSet(String endpointName) {
        return this.endpoints.get(endpointName);
    }

    public EndpointSet getEndpointSet() {
        return this.endpoints.get("");
    }

    public Collection<Endpoint> getEndpoints() {
        HashSet<Endpoint> x = new HashSet<Endpoint>();
        this.endpoints.forEach((k, eps) -> eps.forEach((op, ep) -> x.add((Endpoint)ep)));
        return x;
    }

    public void forEachEndpoint(Consumer<Endpoint> action) {
        this.endpoints.forEach((k, eps) -> eps.forEach((op, ep) -> action.accept((Endpoint)ep)));
    }

    public List<Endpoint> getEndpoints(Operation operation) {
        Collection x = this.operationsMap.get((Object)operation);
        return x;
    }

    public Collection<Operation> getOperations() {
        return this.operationsMap.keySet();
    }

    public boolean hasOperation(Operation operation) {
        return this.operationsMap.keySet().contains(operation);
    }

    public void setEndpointProcessors(OperationRegistry operationRegistry) {
        this.forEachEndpoint(ep -> {
            if (ep.getProcessor() == null) {
                ep.setProcessor(operationRegistry.findHandler(ep.getOperation()));
            }
        });
    }

    private void ensureEnpointProcessors() {
        this.forEachEndpoint(ep -> {
            if (ep.getProcessor() == null) {
                String x = NodeFmtLib.strNT(ep.getOperation().getId());
                Fuseki.configLog.warn("No processor for operation " + x);
            }
        });
    }

    public DispatchFunction getDefaultOperationChooser() {
        return this.plainOperationChooser;
    }

    public void goActive() {
        this.ensureEnpointProcessors();
        this.offlineInProgress.set(false);
        this.acceptingRequests.set(true);
        this.state = DataServiceStatus.ACTIVE;
    }

    public void goOffline() {
        this.offlineInProgress.set(true);
        this.acceptingRequests.set(false);
        this.state = DataServiceStatus.OFFLINE;
    }

    public boolean isAcceptingRequests() {
        return this.acceptingRequests.get();
    }

    public CounterSet getCounters() {
        return this.counters;
    }

    public long getRequests() {
        return this.counters.value(CounterName.Requests);
    }

    public long getRequestsGood() {
        return this.counters.value(CounterName.RequestsGood);
    }

    public long getRequestsBad() {
        return this.counters.value(CounterName.RequestsBad);
    }

    public void startTxn(TxnType mode) {
        this.check(DataServiceStatus.ACTIVE);
        this.activeTxn.getAndIncrement();
        this.totalTxn.getAndIncrement();
    }

    public void finishTxn() {
        this.activeTxn.decrementAndGet();
    }

    private void check(DataServiceStatus status) {
        if (this.state != status) {
            String msg = String.format("DataService %s: Expected=%s, Actual=%s", new Object[]{this.label(), status, this.state});
            throw new FusekiException(msg);
        }
    }

    public void addShutdownHandler(Consumer<DataService> action) {
        this.shutdownHandlers.add(action);
    }

    public synchronized void shutdown() {
        if (this.state == DataServiceStatus.CLOSING) {
            return;
        }
        this.shutdownHandlers.forEach(action -> action.accept(this));
        DataService.expel(this.dataset);
        this.dataset = null;
        this.state = DataServiceStatus.CLOSED;
    }

    private static void expel(DatasetGraph database) {
        DatasetGraph base = DataService.findTDB(database);
        database.close();
        boolean isTDB1 = TDBInternal.isTDB1(base);
        boolean isTDB2 = org.apache.jena.tdb2.sys.TDBInternal.isTDB2(base);
        if (isTDB1 || isTDB2) {
            if (isTDB1) {
                TDBInternal.expel(base);
            }
            if (isTDB2) {
                org.apache.jena.tdb2.sys.TDBInternal.expel(base);
            }
        }
    }

    private static DatasetGraph findTDB(DatasetGraph dsg) {
        DatasetGraph dsgw = dsg;
        while (dsgw instanceof DatasetGraphWrapper) {
            if (TDBInternal.isTDB1(dsgw)) {
                return dsgw;
            }
            if (org.apache.jena.tdb2.sys.TDBInternal.isTDB2(dsgw)) {
                return dsgw;
            }
            dsgw = ((DatasetGraphWrapper)dsgw).getWrapped();
        }
        return dsgw;
    }

    public AuthPolicy authPolicy() {
        return this.authPolicy;
    }

    public static class Builder {
        private DatasetGraph dataset = null;
        private Map<String, EndpointSet> endpoints = new HashMap<String, EndpointSet>();
        private ListValuedMap<Operation, Endpoint> operationsMap = MultiMapUtils.newListValuedHashMap();
        private DispatchFunction plainOperationChooser = null;
        private AuthPolicy authPolicy = null;

        private Builder() {
        }

        private Builder(DatasetGraph dataset, Map<String, EndpointSet> endpoints, MultiValuedMap<Operation, Endpoint> operationsMap, DispatchFunction plainOperationChooser, AuthPolicy authPolicy) {
            this();
            this.dataset = dataset;
            this.endpoints.putAll(endpoints);
            this.operationsMap.putAll(operationsMap);
            this.plainOperationChooser = plainOperationChooser;
            this.authPolicy = authPolicy;
        }

        public Builder dataset(DatasetGraph dsg) {
            this.dataset = dsg;
            return this;
        }

        public DatasetGraph dataset() {
            return this.dataset;
        }

        public Builder withStdServices(boolean withUpdate) {
            FusekiConfig.populateStdServices(this, withUpdate);
            return this;
        }

        public Builder addEndpoint(Operation operation) {
            return this.addEndpoint(operation, null, null);
        }

        public Builder addEndpoint(Operation operation, AuthPolicy authPolicy) {
            return this.addEndpoint(operation, null, authPolicy);
        }

        public Builder addEndpoint(Operation operation, String endpointName) {
            return this.addEndpoint(operation, endpointName, null);
        }

        public Builder addEndpoint(Operation operation, String endpointName, AuthPolicy authPolicy) {
            Endpoint endpoint = Endpoint.create(operation, endpointName, authPolicy);
            return this.addEndpoint(endpoint);
        }

        public Builder addEndpoint(Endpoint endpoint) {
            return this.addEndpoint$(endpoint);
        }

        private Builder addEndpoint$(Endpoint endpoint) {
            EndpointSet eps = this.endpoints.computeIfAbsent(endpoint.getName(), k -> new EndpointSet((String)k));
            eps.put(endpoint);
            if (!this.operationsMap.containsMapping(endpoint.getOperation(), endpoint)) {
                this.operationsMap.put(endpoint.getOperation(), endpoint);
            }
            return this;
        }

        private void removeEndpoint$(Endpoint endpoint) {
            EndpointSet eps = this.endpoints.get(endpoint.getName());
            if (eps == null) {
                return;
            }
            eps.remove(endpoint);
            this.operationsMap.removeMapping(endpoint.getOperation(), endpoint);
        }

        public Builder setPlainOperationChooser(DispatchFunction plainOperationChooser) {
            this.plainOperationChooser = plainOperationChooser;
            return this;
        }

        public Builder setAuthPolicy(AuthPolicy authPolicy) {
            this.authPolicy = authPolicy;
            return this;
        }

        public DataService build() {
            return new DataService(this.dataset, this.endpoints, this.operationsMap, this.plainOperationChooser, this.authPolicy);
        }
    }
}

