/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.matchers;

import com.github.fge.lambdas.Throwing;
import com.google.common.annotations.VisibleForTesting;
import jakarta.mail.MessagingException;
import jakarta.mail.Part;
import java.io.IOException;
import java.util.Collection;
import java.util.Comparator;
import java.util.Locale;
import java.util.Optional;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.james.core.MailAddress;
import org.apache.james.mime4j.codec.DecodeMonitor;
import org.apache.james.mime4j.codec.DecoderUtil;
import org.apache.james.mime4j.dom.field.ContentDispositionField;
import org.apache.james.mime4j.dom.field.ContentTypeField;
import org.apache.james.mime4j.field.ContentDispositionFieldLenientImpl;
import org.apache.james.mime4j.field.ContentTypeFieldLenientImpl;
import org.apache.james.mime4j.stream.Field;
import org.apache.james.mime4j.stream.RawFieldParser;
import org.apache.james.mime4j.util.ContentUtil;
import org.apache.james.mime4j.util.MimeParameterMapping;
import org.apache.james.mime4j.util.MimeUtil;
import org.apache.james.transport.matchers.utils.MimeWalk;
import org.apache.mailet.Mail;
import org.apache.mailet.base.GenericMatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AttachmentFileNameIs
extends GenericMatcher {
    private static final Logger LOGGER = LoggerFactory.getLogger(AttachmentFileNameIs.class);
    protected static final String ZIP_SUFFIX = ".zip";
    @VisibleForTesting
    MimeWalk.Configuration configuration = MimeWalk.Configuration.DEFAULT;

    public static String cleanFileName(String fileName) {
        return DecoderUtil.decodeEncodedWords((String)fileName.toLowerCase(Locale.US).trim(), (DecodeMonitor)DecodeMonitor.SILENT);
    }

    public void init() throws MessagingException {
        this.configuration = MimeWalk.Configuration.parse(this.getCondition());
    }

    public Collection<MailAddress> match(Mail mail) throws MessagingException {
        return new MimeWalk(this.configuration, this::partMatch).matchMail(mail);
    }

    private boolean partMatch(Part part) throws MessagingException {
        Optional<ContentDispositionField> contentDispositionField = Optional.ofNullable(part.getHeader("Content-Disposition")).map(headers -> headers[0]).map(value -> "Content-Disposition: " + value).map(ContentUtil::encode).map(Throwing.function(arg_0 -> ((RawFieldParser)RawFieldParser.DEFAULT).parseField(arg_0))).map(raw -> (ContentDispositionField)ContentDispositionFieldLenientImpl.PARSER.parse((Field)raw, DecodeMonitor.SILENT));
        Optional<ContentTypeField> contentTypeField = Optional.ofNullable(part.getHeader("Content-Type")).map(headers -> headers[0]).map(value -> "Content-Type: " + value).map(ContentUtil::encode).map(Throwing.function(arg_0 -> ((RawFieldParser)RawFieldParser.DEFAULT).parseField(arg_0))).map(raw -> (ContentTypeField)ContentTypeFieldLenientImpl.PARSER.parse((Field)raw, DecodeMonitor.SILENT));
        return this.extractFilename(contentTypeField, contentDispositionField).map(AttachmentFileNameIs::cleanFileName).map(Throwing.function(fileName -> {
            if (this.matchFound((String)fileName)) {
                if (this.configuration.isDebug()) {
                    LOGGER.debug("matched {}", fileName);
                }
                return true;
            }
            if (this.configuration.unzipIsRequested() && fileName.endsWith(ZIP_SUFFIX) && this.matchFoundInZip(part)) {
                return true;
            }
            return false;
        })).orElse(false);
    }

    private Optional<String> extractFilename(Optional<ContentTypeField> contentTypeField, Optional<ContentDispositionField> contentDispositionField) {
        Comparator comparingName = (e1, e2) -> this.extractParameterName((String)e1.getKey()).compareTo(this.extractParameterName((String)e2.getKey()));
        Comparator comparingPartNumbers = (e1, e2) -> Integer.compare(this.extractPartNumber((String)e1.getKey()), this.extractPartNumber((String)e2.getKey()));
        return contentTypeField.flatMap(field -> {
            MimeParameterMapping mimeParameterMapping = new MimeParameterMapping();
            field.getParameters().entrySet().stream().sorted(comparingName.thenComparing(comparingPartNumbers)).forEach(e -> mimeParameterMapping.addParameter((String)e.getKey(), (String)e.getValue()));
            return Optional.ofNullable(mimeParameterMapping.get("name"));
        }).or(() -> contentDispositionField.map(ContentDispositionField::getFilename)).map(MimeUtil::unscrambleHeaderValue);
    }

    String extractParameterName(String name) {
        int separatorPosition = name.indexOf(42);
        if (separatorPosition > 0) {
            return name.substring(0, separatorPosition);
        }
        return name;
    }

    String removeTrailingSeparator(String name) {
        int separatorPosition = name.indexOf(42);
        if (separatorPosition > 0) {
            return name.substring(0, separatorPosition);
        }
        return name;
    }

    int extractPartNumber(String name) {
        int separatorPosition = name.indexOf(42);
        if (separatorPosition > 0) {
            try {
                return Integer.parseInt(this.removeTrailingSeparator(name.substring(separatorPosition + 1)));
            }
            catch (NumberFormatException e) {
                return 0;
            }
        }
        return 0;
    }

    protected boolean matchFound(String fileName) {
        for (MimeWalk.Mask mask1 : this.configuration.masks()) {
            if (!mask1.match(fileName)) continue;
            return true;
        }
        return false;
    }

    protected boolean matchFoundInZip(Part part) throws MessagingException, IOException {
        try (ZipInputStream zis = new ZipInputStream(part.getInputStream());){
            ZipEntry zipEntry;
            while ((zipEntry = zis.getNextEntry()) != null) {
                String fileName = zipEntry.getName();
                if (!this.matchFound(fileName)) continue;
                if (this.configuration.unzipIsRequested()) {
                    LOGGER.debug("matched {}({})", (Object)part.getFileName(), (Object)fileName);
                }
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }
}

