/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jcr2spi.query;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.ValueFactory;
import javax.jcr.query.InvalidQueryException;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.qom.QueryObjectModel;
import javax.jcr.query.qom.QueryObjectModelFactory;
import org.apache.jackrabbit.commons.query.QueryObjectModelBuilder;
import org.apache.jackrabbit.commons.query.QueryObjectModelBuilderRegistry;
import org.apache.jackrabbit.jcr2spi.ItemManager;
import org.apache.jackrabbit.jcr2spi.ManagerProvider;
import org.apache.jackrabbit.jcr2spi.WorkspaceManager;
import org.apache.jackrabbit.jcr2spi.query.QueryImpl;
import org.apache.jackrabbit.jcr2spi.query.QueryObjectModelImpl;
import org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;
import org.apache.jackrabbit.spi.commons.name.NameConstants;
import org.apache.jackrabbit.spi.commons.query.qom.QueryObjectModelFactoryImpl;
import org.apache.jackrabbit.spi.commons.query.qom.QueryObjectModelTree;

public class QueryManagerImpl
implements QueryManager {
    private final Session session;
    private final ValueFactory valueFactory;
    private final ManagerProvider mgrProvider;
    private final ItemManager itemMgr;
    private final WorkspaceManager wspManager;

    public QueryManagerImpl(Session session, ManagerProvider mgrProvider, ItemManager itemMgr, WorkspaceManager wspManager) throws RepositoryException {
        this.session = session;
        this.valueFactory = mgrProvider.getJcrValueFactory();
        this.mgrProvider = mgrProvider;
        this.itemMgr = itemMgr;
        this.wspManager = wspManager;
    }

    @Override
    public Query createQuery(String statement, String language) throws InvalidQueryException, RepositoryException {
        this.checkIsAlive();
        return new QueryImpl(this.session, this.mgrProvider, this.itemMgr, this.wspManager, statement, language, null);
    }

    @Override
    public Query getQuery(Node node) throws InvalidQueryException, RepositoryException {
        this.checkIsAlive();
        NamePathResolver resolver = this.mgrProvider.getNamePathResolver();
        if (!node.isNodeType(resolver.getJCRName(NameConstants.NT_QUERY))) {
            throw new InvalidQueryException("Node is not of type nt:query");
        }
        if (node.getSession() != this.session) {
            throw new InvalidQueryException("Node belongs to a different session.");
        }
        String statement = node.getProperty(resolver.getJCRName(NameConstants.JCR_STATEMENT)).getString();
        String language = node.getProperty(resolver.getJCRName(NameConstants.JCR_LANGUAGE)).getString();
        if ("JCR-JQOM".equals(language)) {
            QOMFactory qomFactory = new QOMFactory(node, resolver);
            QueryObjectModelBuilder builder = QueryObjectModelBuilderRegistry.getQueryObjectModelBuilder(language);
            return builder.createQueryObjectModel(statement, qomFactory, this.valueFactory);
        }
        return new QueryImpl(this.session, this.mgrProvider, this.itemMgr, this.wspManager, statement, language, node);
    }

    @Override
    public String[] getSupportedQueryLanguages() throws RepositoryException {
        return this.wspManager.getSupportedQueryLanguages();
    }

    @Override
    public QueryObjectModelFactory getQOMFactory() {
        return new QOMFactory(null, this.mgrProvider.getNamePathResolver());
    }

    private void checkIsAlive() throws RepositoryException {
        if (!this.session.isLive()) {
            throw new RepositoryException("corresponding session has been closed");
        }
    }

    private class QOMFactory
    extends QueryObjectModelFactoryImpl {
        private final Node node;

        public QOMFactory(Node node, NamePathResolver resolver) {
            super(resolver);
            this.node = node;
        }

        @Override
        protected QueryObjectModel createQuery(QueryObjectModelTree qomTree) throws InvalidQueryException, RepositoryException {
            return new QueryObjectModelImpl(QueryManagerImpl.this.session, QueryManagerImpl.this.mgrProvider, QueryManagerImpl.this.itemMgr, QueryManagerImpl.this.wspManager, qomTree, this.node);
        }
    }
}

