/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.commons.xml;

import java.io.IOException;
import javax.xml.parsers.DocumentBuilderFactory;
import org.xml.sax.EntityResolver;

public class XMLFactories {
    private XMLFactories() {
    }

    public static DocumentBuilderFactory safeDocumentBuilderFactory() {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setIgnoringComments(false);
        factory.setIgnoringElementContentWhitespace(true);
        factory.setXIncludeAware(false);
        factory.setExpandEntityReferences(false);
        String feature = null;
        try {
            feature = "http://javax.xml.XMLConstants/feature/secure-processing";
            factory.setFeature(feature, true);
            feature = "http://apache.org/xml/features/disallow-doctype-decl";
            factory.setFeature(feature, true);
            feature = "http://apache.org/xml/features/nonvalidating/load-external-dtd";
            factory.setFeature(feature, false);
            feature = "http://xml.org/sax/features/external-general-entities";
            factory.setFeature(feature, false);
            feature = "http://xml.org/sax/features/external-parameter-entities";
            factory.setFeature(feature, false);
        }
        catch (Exception ex) {
            throw new IllegalStateException("Secure processing feature '" + feature + "' not supported by the DocumentBuilderFactory: " + factory.getClass().getName(), ex);
        }
        return factory;
    }

    public static EntityResolver nonResolvingEntityResolver() {
        return (publicId, systemId) -> {
            throw new IOException("This parser does not support resolution of external entities (publicId: " + publicId + ", systemId: " + systemId + ")");
        };
    }
}

