/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.standalone.cli.version;

import org.apache.commons.chain.Command;
import org.apache.commons.chain.Context;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jackrabbit.standalone.cli.CommandHelper;

public class RemoveVersion
implements Command {
    private static Log log = LogFactory.getLog(RemoveVersion.class);
    private String pathKey = "path";
    private String nameKey = "name";

    @Override
    public boolean execute(Context ctx) throws Exception {
        String path = (String)ctx.get(this.pathKey);
        String versionName = (String)ctx.get(this.nameKey);
        if (log.isDebugEnabled()) {
            log.debug("Remove version " + versionName + " from node " + path);
        }
        CommandHelper.getNode(ctx, path).getVersionHistory().removeVersion(versionName);
        return false;
    }

    public String getPathKey() {
        return this.pathKey;
    }

    public void setPathKey(String pathKey) {
        this.pathKey = pathKey;
    }

    public String getNameKey() {
        return this.nameKey;
    }

    public void setNameKey(String versionNameKey) {
        this.nameKey = versionNameKey;
    }
}

