/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.standalone.cli;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.TreeMap;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.collections4.iterators.IteratorChain;
import org.apache.jackrabbit.standalone.cli.Argument;
import org.apache.jackrabbit.standalone.cli.CommandHelper;
import org.apache.jackrabbit.standalone.cli.Flag;
import org.apache.jackrabbit.standalone.cli.Option;

public class CommandLine
implements Comparable,
Cloneable {
    protected static ResourceBundle bundle = CommandHelper.getBundle();
    private String name;
    private String description;
    private String impl;
    private Collection alias = new ArrayList();
    private Map options = new TreeMap();
    private Map flags = new TreeMap();
    private Map arguments = new TreeMap();

    public Collection getRequiredArguments() {
        Predicate p = new Predicate(){

            public boolean evaluate(Object o) {
                Argument arg = (Argument)o;
                return arg.isRequired();
            }
        };
        return CollectionUtils.select(this.arguments.values(), p);
    }

    public Collection getRequiredOptions() {
        Predicate p = new Predicate(){

            public boolean evaluate(Object o) {
                Option opt = (Option)o;
                return opt.isRequired();
            }
        };
        return CollectionUtils.select(this.options.values(), p);
    }

    public String getDescription() {
        return this.description;
    }

    public String getLocalizedDescription() {
        if (this.description == null) {
            return bundle.getString("cmd." + this.name);
        }
        return bundle.getString(this.description);
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Map getFlags() {
        return this.flags;
    }

    public void setFlags(Map flags) {
        this.flags = flags;
    }

    public String getImpl() {
        return this.impl;
    }

    public void setImpl(String impl) {
        this.impl = impl;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Map getOptions() {
        return this.options;
    }

    public void setOptions(Map options) {
        this.options = options;
    }

    public int compareTo(Object o) {
        CommandLine cl = (CommandLine)o;
        return this.name.compareTo(cl.name);
    }

    public Iterator getAllParameters() {
        IteratorChain chain = new IteratorChain();
        chain.addIterator(this.getArguments().values().iterator());
        chain.addIterator(this.getOptions().values().iterator());
        chain.addIterator(this.getFlags().values().iterator());
        return chain;
    }

    public Iterator getRequiredParameters() {
        IteratorChain chain = new IteratorChain();
        chain.addIterator(this.getRequiredArguments().iterator());
        chain.addIterator(this.getRequiredOptions().iterator());
        return chain;
    }

    public void addArgument(Argument arg) {
        if (this.arguments.containsKey(new Integer(arg.getPosition()))) {
            throw new IllegalArgumentException("there's an argument in the position in command " + this.name);
        }
        if (arg.getArgName() == null) {
            arg.setArgName("cmd." + this.getName() + "." + arg.getName());
        }
        if (arg.getDescription() == null) {
            arg.setDescription("cmd." + this.getName() + "." + arg.getName() + ".desc");
        }
        this.arguments.put(new Integer(arg.getPosition()), arg);
    }

    public void addOption(Option opt) {
        if (opt.getArgName() == null) {
            opt.setArgName("cmd." + this.getName() + "." + opt.getName());
        }
        if (opt.getDescription() == null) {
            opt.setDescription("cmd." + this.getName() + "." + opt.getName() + ".desc");
        }
        this.options.put(opt.getName(), opt);
    }

    public void addFlag(Flag flag) {
        if (flag.getDescription() == null) {
            flag.setDescription("cmd." + this.getName() + "." + flag.getName() + ".desc");
        }
        this.flags.put(flag.getName(), flag);
    }

    public Map getArguments() {
        return this.arguments;
    }

    public void setArguments(Map arguments) {
        this.arguments = arguments;
    }

    public Collection getAlias() {
        return this.alias;
    }

    public void setAlias(Collection alias) {
        this.alias = alias;
    }

    public void addAlias(String alias) {
        this.alias.add(alias);
    }

    public Object clone() {
        CommandLine cl = new CommandLine();
        cl.alias = this.alias;
        for (Argument arg : this.arguments.values()) {
            cl.addArgument((Argument)arg.clone());
        }
        cl.description = this.description;
        for (Flag f : this.flags.values()) {
            cl.addFlag((Flag)f.clone());
        }
        cl.impl = this.impl;
        cl.name = this.name;
        for (Option o : this.options.values()) {
            cl.addOption((Option)o.clone());
        }
        return cl;
    }

    public String toString() {
        return "CommandLine-" + this.getName() + "(" + this.impl + ")";
    }
}

