/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jcr2spi;

import java.util.Map;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.RepositoryFactory;
import org.apache.jackrabbit.jcr2spi.RepositoryImpl;
import org.apache.jackrabbit.jcr2spi.config.CacheBehaviour;
import org.apache.jackrabbit.jcr2spi.config.RepositoryConfig;
import org.apache.jackrabbit.spi.RepositoryService;
import org.apache.jackrabbit.spi.RepositoryServiceFactory;
import org.apache.jackrabbit.spi.commons.logging.LogWriterProvider;
import org.apache.jackrabbit.spi.commons.logging.SpiLoggerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Jcr2spiRepositoryFactory
implements RepositoryFactory {
    static final Logger log = LoggerFactory.getLogger(Jcr2spiRepositoryFactory.class);
    public static final String PARAM_REPOSITORY_SERVICE_FACTORY = "org.apache.jackrabbit.spi.RepositoryServiceFactory";
    public static final String PARAM_REPOSITORY_CONFIG = "org.apache.jackrabbit.jcr2spi.RepositoryConfig";
    public static final String PARAM_CACHE_BEHAVIOR = "org.apache.jackrabbit.jcr2spi.CacheBehaviour";
    public static final CacheBehaviour DEFAULT_CACHE_BEHAVIOR = CacheBehaviour.INVALIDATE;
    public static final String PARAM_ITEM_CACHE_SIZE = "org.apache.jackrabbit.jcr2spi.ItemCacheSize";
    public static final int DEFAULT_ITEM_CACHE_SIZE = 5000;
    public static final String PARAM_POLL_TIME_OUT = "org.apache.jackrabbit.jcr2spi.PollTimeOut";
    public static final int DEFAULT_POLL_TIME_OUT = 3000;
    public static final String PARAM_LOG_WRITER_PROVIDER = "org.apache.jackrabbit.spi.commons.logging.LogWriterProvider";

    @Override
    public Repository getRepository(Map parameters) throws RepositoryException {
        RepositoryConfig config;
        RepositoryServiceFactory serviceFactory = Jcr2spiRepositoryFactory.getServiceFactory(parameters);
        Object configParam = parameters.get(PARAM_REPOSITORY_CONFIG);
        if (serviceFactory == null && configParam == null) {
            return null;
        }
        if (configParam instanceof RepositoryConfig) {
            config = (RepositoryConfig)configParam;
            if (serviceFactory != null) {
                log.warn("Ignoring {} since {} was specified", (Object)PARAM_REPOSITORY_SERVICE_FACTORY, (Object)PARAM_REPOSITORY_CONFIG);
            }
        } else {
            if (serviceFactory == null) {
                return null;
            }
            config = new RepositoryConfigImpl(serviceFactory, parameters);
        }
        config = SpiLoggerConfig.wrap(config, parameters);
        return RepositoryImpl.create(config);
    }

    private static RepositoryServiceFactory getServiceFactory(Map<?, ?> parameters) throws RepositoryException {
        Object serviceFactoryParam = parameters.get(PARAM_REPOSITORY_SERVICE_FACTORY);
        if (serviceFactoryParam == null) {
            return null;
        }
        log.debug("Acquiring RepositoryServiceFactory from {}", (Object)PARAM_REPOSITORY_SERVICE_FACTORY);
        if (serviceFactoryParam instanceof RepositoryServiceFactory) {
            log.debug("Found RepositoryServiceFactory {}", serviceFactoryParam);
            return (RepositoryServiceFactory)serviceFactoryParam;
        }
        if (serviceFactoryParam instanceof String) {
            String serviceFactoryName = (String)serviceFactoryParam;
            log.debug("Found RepositoryServiceFactory class name {}", (Object)serviceFactoryName);
            try {
                Class<?> serviceFactoryClass;
                try {
                    serviceFactoryClass = Class.forName(serviceFactoryName, true, Thread.currentThread().getContextClassLoader());
                }
                catch (ClassNotFoundException e) {
                    serviceFactoryClass = Class.forName(serviceFactoryName);
                }
                Object serviceFactory = serviceFactoryClass.newInstance();
                if (serviceFactory instanceof RepositoryServiceFactory) {
                    log.debug("Found RepositoryServiceFactory {}", serviceFactory);
                    return (RepositoryServiceFactory)serviceFactory;
                }
                String msg = "Error acquiring RepositoryServiceFactory " + String.valueOf(serviceFactoryParam);
                log.error(msg);
                throw new RepositoryException(msg);
            }
            catch (Exception e) {
                String msg = "Error acquiring RepositoryServiceFactory";
                log.error(msg, e);
                throw new RepositoryException(msg, e);
            }
        }
        String msg = "Error acquiring RepositoryServiceFactory from " + String.valueOf(serviceFactoryParam);
        log.error(msg);
        throw new RepositoryException(msg);
    }

    private static class SpiLoggerConfig
    implements RepositoryConfig {
        private final RepositoryConfig config;
        private final RepositoryService service;

        private SpiLoggerConfig(RepositoryConfig config, Map<?, ?> parameters) throws RepositoryException {
            this.config = config;
            Object lwProvider = parameters.get(Jcr2spiRepositoryFactory.PARAM_LOG_WRITER_PROVIDER);
            this.service = lwProvider instanceof LogWriterProvider ? SpiLoggerFactory.create(config.getRepositoryService(), (LogWriterProvider)lwProvider) : SpiLoggerFactory.create(config.getRepositoryService());
        }

        public static RepositoryConfig wrap(RepositoryConfig config, Map<?, ?> parameters) throws RepositoryException {
            if (config == null || parameters == null || !parameters.containsKey(Jcr2spiRepositoryFactory.PARAM_LOG_WRITER_PROVIDER)) {
                return config;
            }
            return new SpiLoggerConfig(config, parameters);
        }

        @Override
        public CacheBehaviour getCacheBehaviour() {
            return this.config.getCacheBehaviour();
        }

        @Override
        public int getItemCacheSize() {
            return this.config.getItemCacheSize();
        }

        @Override
        public int getPollTimeout() {
            return this.config.getPollTimeout();
        }

        @Override
        public <T> T getConfiguration(String name, T defaultValue) {
            return this.config.getConfiguration(name, defaultValue);
        }

        @Override
        public RepositoryService getRepositoryService() throws RepositoryException {
            return this.service;
        }
    }

    public static class RepositoryConfigImpl
    implements RepositoryConfig {
        private final RepositoryServiceFactory serviceFactory;
        private final CacheBehaviour cacheBehaviour;
        private final int itemCacheSize;
        private final int pollTimeOut;
        private final Map<?, ?> parameters;
        private RepositoryService repositoryService;

        public RepositoryConfigImpl(RepositoryServiceFactory serviceFactory, Map<?, ?> parameters) throws RepositoryException {
            this.serviceFactory = serviceFactory;
            this.cacheBehaviour = RepositoryConfigImpl.getCacheBehaviour(parameters);
            this.itemCacheSize = RepositoryConfigImpl.getItemCacheSize(parameters);
            this.pollTimeOut = RepositoryConfigImpl.getPollTimeout(parameters);
            this.parameters = parameters;
        }

        @Override
        public CacheBehaviour getCacheBehaviour() {
            return this.cacheBehaviour;
        }

        @Override
        public int getItemCacheSize() {
            return this.itemCacheSize;
        }

        @Override
        public int getPollTimeout() {
            return this.pollTimeOut;
        }

        @Override
        public <T> T getConfiguration(String name, T defaultValue) {
            if (this.parameters.containsKey(name)) {
                Class<?> clazz;
                Object value = this.parameters.get(name);
                Class<?> clazz2 = clazz = defaultValue == null ? value.getClass() : defaultValue.getClass();
                if (clazz.isAssignableFrom(value.getClass())) {
                    return (T)value;
                }
            }
            return defaultValue;
        }

        @Override
        public RepositoryService getRepositoryService() throws RepositoryException {
            if (this.repositoryService == null) {
                this.repositoryService = this.serviceFactory.createRepositoryService(this.parameters);
            }
            return this.repositoryService;
        }

        private static CacheBehaviour getCacheBehaviour(Map<?, ?> parameters) throws RepositoryException {
            Object paramCacheBehaviour = parameters.get(Jcr2spiRepositoryFactory.PARAM_CACHE_BEHAVIOR);
            log.debug("Setting CacheBehaviour from {}", (Object)Jcr2spiRepositoryFactory.PARAM_CACHE_BEHAVIOR);
            if (paramCacheBehaviour == null) {
                log.debug("{} not set, defaulting to {}", (Object)Jcr2spiRepositoryFactory.PARAM_CACHE_BEHAVIOR, (Object)DEFAULT_CACHE_BEHAVIOR);
                return DEFAULT_CACHE_BEHAVIOR;
            }
            if (paramCacheBehaviour instanceof CacheBehaviour) {
                log.debug("Setting CacheBehaviour to {}", paramCacheBehaviour);
                return (CacheBehaviour)paramCacheBehaviour;
            }
            if (paramCacheBehaviour instanceof String) {
                String cacheBehaviour = (String)paramCacheBehaviour;
                if ("invalidate".equals(cacheBehaviour)) {
                    log.debug("Setting CacheBehaviour to {}", (Object)CacheBehaviour.INVALIDATE);
                    return CacheBehaviour.INVALIDATE;
                }
                if ("observation".equals(cacheBehaviour)) {
                    log.debug("Setting CacheBehaviour to {}", (Object)CacheBehaviour.OBSERVATION);
                    return CacheBehaviour.OBSERVATION;
                }
                log.error("Invalid valid for CacheBehaviour: {} {}", (Object)Jcr2spiRepositoryFactory.PARAM_CACHE_BEHAVIOR, (Object)cacheBehaviour);
                throw new RepositoryException("Invalid value for CacheBehaviour: " + cacheBehaviour);
            }
            String msg = "Invalid value for CacheBehaviour: " + String.valueOf(paramCacheBehaviour);
            log.error(msg);
            throw new RepositoryException(msg);
        }

        private static int getItemCacheSize(Map<?, ?> parameters) throws RepositoryException {
            Object paramItemCacheSize = parameters.get(Jcr2spiRepositoryFactory.PARAM_ITEM_CACHE_SIZE);
            log.debug("Setting ItemCacheSize from {}", (Object)Jcr2spiRepositoryFactory.PARAM_ITEM_CACHE_SIZE);
            if (paramItemCacheSize == null) {
                log.debug("{} not set, defaulting to {}", (Object)Jcr2spiRepositoryFactory.PARAM_ITEM_CACHE_SIZE, (Object)5000);
                return 5000;
            }
            if (paramItemCacheSize instanceof Integer) {
                log.debug("Setting ItemCacheSize to {}", paramItemCacheSize);
                return (Integer)paramItemCacheSize;
            }
            if (paramItemCacheSize instanceof String) {
                try {
                    log.debug("Setting ItemCacheSize to {}", paramItemCacheSize);
                    return Integer.parseInt((String)paramItemCacheSize);
                }
                catch (NumberFormatException e) {
                    String msg = "Invalid value for ItemCacheSize: " + String.valueOf(paramItemCacheSize);
                    log.error(msg);
                    throw new RepositoryException(msg, e);
                }
            }
            String msg = "Invalid value for ItemCacheSize: " + String.valueOf(paramItemCacheSize);
            log.error(msg);
            throw new RepositoryException(msg);
        }

        private static int getPollTimeout(Map<?, ?> parameters) throws RepositoryException {
            Object paramPollTimeOut = parameters.get(Jcr2spiRepositoryFactory.PARAM_POLL_TIME_OUT);
            log.debug("Setting PollTimeout from {}", (Object)Jcr2spiRepositoryFactory.PARAM_POLL_TIME_OUT);
            if (paramPollTimeOut == null) {
                log.debug("{} not set, defaulting to {}", (Object)Jcr2spiRepositoryFactory.PARAM_POLL_TIME_OUT, (Object)3000);
                return 3000;
            }
            if (paramPollTimeOut instanceof Integer) {
                log.debug("Setting PollTimeout to {}", paramPollTimeOut);
                return (Integer)paramPollTimeOut;
            }
            if (paramPollTimeOut instanceof String) {
                try {
                    log.debug("Setting PollTimeout to {}", paramPollTimeOut);
                    return Integer.parseInt((String)paramPollTimeOut);
                }
                catch (NumberFormatException e) {
                    String msg = "Invalid value for PollTimeout: " + String.valueOf(paramPollTimeOut);
                    log.error(msg);
                    throw new RepositoryException(msg, e);
                }
            }
            String msg = "Invalid value for PollTimeout: " + String.valueOf(paramPollTimeOut);
            log.error(msg);
            throw new RepositoryException(msg);
        }
    }
}

