/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.security.authentication;

import java.io.UnsupportedEncodingException;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.jcr.Credentials;
import javax.jcr.SimpleCredentials;
import org.apache.jackrabbit.core.security.user.PasswordUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CryptedSimpleCredentials
implements Credentials {
    private static final Logger log = LoggerFactory.getLogger(CryptedSimpleCredentials.class);
    private final String hashedPassword;
    private final String userId;
    private final Map<String, Object> attributes;

    @Deprecated
    public CryptedSimpleCredentials(SimpleCredentials credentials) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        this.userId = credentials.getUserID();
        if (this.userId == null || this.userId.length() == 0) {
            throw new IllegalArgumentException();
        }
        char[] pwd = credentials.getPassword();
        if (pwd == null) {
            throw new IllegalArgumentException();
        }
        String password = new String(pwd);
        this.hashedPassword = PasswordUtility.buildPasswordHash(password);
        String[] attNames = credentials.getAttributeNames();
        this.attributes = new HashMap<String, Object>(attNames.length);
        for (String attName : attNames) {
            this.attributes.put(attName, credentials.getAttribute(attName));
        }
    }

    public CryptedSimpleCredentials(String userId, String hashedPassword) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        if (userId == null || userId.length() == 0) {
            throw new IllegalArgumentException("Invalid userID: The userID must have a length > 0.");
        }
        if (hashedPassword == null) {
            throw new IllegalArgumentException("Password may not be null.");
        }
        this.userId = userId;
        if (PasswordUtility.isPlainTextPassword(hashedPassword)) {
            log.warn("Plain text password -> Using default algorithm to create digest.");
            this.hashedPassword = PasswordUtility.buildPasswordHash(hashedPassword);
        } else {
            this.hashedPassword = hashedPassword;
        }
        this.attributes = Collections.emptyMap();
    }

    public String getUserID() {
        return this.userId;
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public String[] getAttributeNames() {
        return this.attributes.keySet().toArray(new String[this.attributes.size()]);
    }

    public String getAlgorithm() {
        return PasswordUtility.extractAlgorithm(this.hashedPassword);
    }

    public String getPassword() {
        return this.hashedPassword;
    }

    public boolean matches(SimpleCredentials credentials) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        if (this.getUserID().equalsIgnoreCase(credentials.getUserID())) {
            return PasswordUtility.isSame(this.hashedPassword, String.valueOf(credentials.getPassword()));
        }
        return false;
    }
}

