/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.retention;

import java.util.ArrayList;
import javax.jcr.AccessDeniedException;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.lock.LockException;
import javax.jcr.retention.Hold;
import javax.jcr.retention.RetentionManager;
import javax.jcr.retention.RetentionPolicy;
import javax.jcr.version.VersionException;
import org.apache.jackrabbit.core.NodeImpl;
import org.apache.jackrabbit.core.PropertyImpl;
import org.apache.jackrabbit.core.ProtectedItemModifier;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.retention.HoldImpl;
import org.apache.jackrabbit.core.retention.RetentionPolicyImpl;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.NameFactory;
import org.apache.jackrabbit.spi.commons.conversion.NameResolver;
import org.apache.jackrabbit.spi.commons.name.NameFactoryImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetentionManagerImpl
extends ProtectedItemModifier
implements RetentionManager {
    private static Logger log = LoggerFactory.getLogger(RetentionManagerImpl.class);
    private static final NameFactory NAME_FACTORY = NameFactoryImpl.getInstance();
    static final Name REP_RETENTION_MANAGEABLE = NAME_FACTORY.create("internal", "RetentionManageable");
    static final Name REP_HOLD = NAME_FACTORY.create("internal", "hold");
    static final Name REP_RETENTION_POLICY = NAME_FACTORY.create("internal", "retentionPolicy");
    private final SessionImpl session;

    public RetentionManagerImpl(SessionImpl session) {
        super(2048);
        this.session = session;
    }

    @Override
    public Hold[] getHolds(String absPath) throws PathNotFoundException, AccessDeniedException, RepositoryException {
        NodeImpl n = (NodeImpl)this.session.getNode(absPath);
        this.session.getAccessManager().checkPermission(this.session.getQPath(absPath), 2048);
        Hold[] holds = n.isNodeType(REP_RETENTION_MANAGEABLE) && n.hasProperty(REP_HOLD) ? HoldImpl.createFromProperty(n.getProperty(REP_HOLD), n.getNodeId()) : new Hold[]{};
        return holds;
    }

    @Override
    public Hold addHold(String absPath, String name, boolean isDeep) throws PathNotFoundException, AccessDeniedException, LockException, VersionException, RepositoryException {
        Value[] vls;
        NodeImpl n = (NodeImpl)this.session.getNode(absPath);
        if (!n.isNodeType(REP_RETENTION_MANAGEABLE)) {
            n.addMixin(REP_RETENTION_MANAGEABLE);
        }
        HoldImpl hold = new HoldImpl(this.session.getQName(name), isDeep, n.getNodeId(), this.session);
        if (n.hasProperty(REP_HOLD)) {
            Value[] vs;
            for (Value v : vs = n.getProperty(REP_HOLD).getValues()) {
                if (!hold.equals(HoldImpl.createFromValue(v, n.getNodeId(), this.session))) continue;
                throw new RepositoryException("Hold already exists.");
            }
            vls = new Value[vs.length + 1];
            System.arraycopy(vs, 0, vls, 0, vs.length);
        } else {
            vls = new Value[1];
        }
        vls[vls.length - 1] = hold.toValue(this.session.getValueFactory());
        this.setProperty(n, REP_HOLD, vls);
        return hold;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void removeHold(String absPath, Hold hold) throws PathNotFoundException, AccessDeniedException, LockException, VersionException, RepositoryException {
        NodeImpl n = (NodeImpl)this.session.getNode(absPath);
        if (!(hold instanceof HoldImpl) || !n.getNodeId().equals(((HoldImpl)hold).getNodeId()) || !n.isNodeType(REP_RETENTION_MANAGEABLE) || !n.hasProperty(REP_HOLD)) throw new RepositoryException("Cannot remove '" + hold.getName() + "' at " + absPath + ".");
        PropertyImpl p = n.getProperty(REP_HOLD);
        Value[] vls = p.getValues();
        ArrayList<Value> newValues = new ArrayList<Value>(vls.length - 1);
        for (Value v : vls) {
            if (hold.equals(HoldImpl.createFromValue(v, n.getNodeId(), this.session))) continue;
            newValues.add(v);
        }
        if (newValues.size() >= vls.length) throw new RepositoryException("Cannot remove '" + hold.getName() + "' at " + absPath + ".");
        if (newValues.size() == 0) {
            this.removeItem(p);
            return;
        } else {
            this.setProperty(n, REP_HOLD, newValues.toArray(new Value[newValues.size()]));
        }
    }

    @Override
    public RetentionPolicy getRetentionPolicy(String absPath) throws PathNotFoundException, AccessDeniedException, RepositoryException {
        NodeImpl n = (NodeImpl)this.session.getNode(absPath);
        this.session.getAccessManager().checkPermission(this.session.getQPath(absPath), 2048);
        RetentionPolicyImpl rPolicy = null;
        if (n.isNodeType(REP_RETENTION_MANAGEABLE) && n.hasProperty(REP_RETENTION_POLICY)) {
            String jcrName = n.getProperty(REP_RETENTION_POLICY).getString();
            rPolicy = new RetentionPolicyImpl(jcrName, n.getNodeId(), (NameResolver)this.session);
        }
        return rPolicy;
    }

    @Override
    public void setRetentionPolicy(String absPath, RetentionPolicy retentionPolicy) throws PathNotFoundException, AccessDeniedException, LockException, VersionException, RepositoryException {
        NodeImpl n = (NodeImpl)this.session.getNode(absPath);
        if (!(retentionPolicy instanceof RetentionPolicyImpl)) {
            throw new RepositoryException("Invalid retention policy.");
        }
        Value retentionReference = this.session.getValueFactory().createValue(retentionPolicy.getName(), 7);
        if (!n.isNodeType(REP_RETENTION_MANAGEABLE)) {
            n.addMixin(REP_RETENTION_MANAGEABLE);
        }
        this.setProperty(n, REP_RETENTION_POLICY, retentionReference);
    }

    @Override
    public void removeRetentionPolicy(String absPath) throws PathNotFoundException, AccessDeniedException, LockException, VersionException, RepositoryException {
        NodeImpl n = (NodeImpl)this.session.getNode(absPath);
        if (!n.isNodeType(REP_RETENTION_MANAGEABLE) || !n.hasProperty(REP_RETENTION_POLICY)) {
            throw new RepositoryException("Cannot remove retention policy at absPath.");
        }
        this.removeItem(n.getProperty(REP_RETENTION_POLICY));
    }
}

