/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.query.InvalidQueryException;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.qom.QueryObjectModel;
import javax.jcr.query.qom.QueryObjectModelFactory;
import org.apache.jackrabbit.core.SearchManager;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.query.AQTQueryFactory;
import org.apache.jackrabbit.core.query.CompoundQueryFactory;
import org.apache.jackrabbit.core.query.QOMQueryFactory;
import org.apache.jackrabbit.core.query.QueryHandler;
import org.apache.jackrabbit.core.session.SessionContext;
import org.apache.jackrabbit.core.session.SessionOperation;
import org.apache.jackrabbit.spi.commons.name.NameConstants;
import org.apache.jackrabbit.spi.commons.query.qom.QueryObjectModelFactoryImpl;
import org.apache.jackrabbit.spi.commons.query.qom.QueryObjectModelTree;

public class QueryManagerImpl
implements QueryManager {
    private final SessionContext sessionContext;
    private final SearchManager searchMgr;
    private final QueryObjectModelFactoryImpl qomFactory;

    public QueryManagerImpl(final SessionContext sessionContext, final SearchManager searchMgr) throws RepositoryException {
        this.sessionContext = sessionContext;
        this.searchMgr = searchMgr;
        this.qomFactory = new QueryObjectModelFactoryImpl(sessionContext){

            @Override
            protected QueryObjectModel createQuery(QueryObjectModelTree qomTree) throws InvalidQueryException, RepositoryException {
                return searchMgr.createQueryObjectModel(sessionContext, qomTree, "JCR-JQOM", null);
            }
        };
    }

    @Override
    public Query createQuery(final String statement, final String language) throws RepositoryException {
        return this.perform(new SessionOperation<Query>(){

            @Override
            public Query perform(SessionContext context) throws RepositoryException {
                QueryFactoryImpl qf = new QueryFactoryImpl(language);
                return qf.createQuery(statement, language);
            }

            public String toString() {
                return "node.createQuery(" + statement + ", " + language + ")";
            }
        });
    }

    @Override
    public Query getQuery(final Node node) throws RepositoryException {
        return this.perform(new SessionOperation<Query>(){

            @Override
            public Query perform(SessionContext context) throws RepositoryException {
                if (!node.isNodeType(context.getJCRName(NameConstants.NT_QUERY))) {
                    throw new InvalidQueryException("Node is not of type nt:query: " + String.valueOf(node));
                }
                String statement = node.getProperty(context.getJCRName(NameConstants.JCR_STATEMENT)).getString();
                String language = node.getProperty(context.getJCRName(NameConstants.JCR_LANGUAGE)).getString();
                QueryFactoryImpl qf = new QueryFactoryImpl(node, language);
                return qf.createQuery(statement, language);
            }

            public String toString() {
                return "queryManager.getQuery(node)";
            }
        });
    }

    @Override
    public String[] getSupportedQueryLanguages() throws RepositoryException {
        List<String> languages = new QueryFactoryImpl("JCR-JQOM").getSupportedLanguages();
        return languages.toArray(new String[languages.size()]);
    }

    @Override
    public QueryObjectModelFactory getQOMFactory() {
        return this.qomFactory;
    }

    public Iterable<Node> getWeaklyReferringNodes(final Node node) throws RepositoryException {
        return this.perform(new SessionOperation<Iterable<Node>>(){

            @Override
            public Iterable<Node> perform(SessionContext context) throws RepositoryException {
                ArrayList<Node> nodes = new ArrayList<Node>();
                try {
                    NodeId nodeId = new NodeId(node.getIdentifier());
                    for (NodeId id : QueryManagerImpl.this.searchMgr.getWeaklyReferringNodes(nodeId)) {
                        nodes.add(QueryManagerImpl.this.sessionContext.getSessionImpl().getNodeById(id));
                    }
                }
                catch (IOException e) {
                    throw new RepositoryException(e);
                }
                return nodes;
            }

            public String toString() {
                return "queryManager.getWeaklyReferringNodes(node)";
            }
        });
    }

    QueryHandler getQueryHandler() {
        return this.searchMgr.getQueryHandler();
    }

    private <T> T perform(SessionOperation<T> operation) throws RepositoryException {
        return this.sessionContext.getSessionState().perform(operation);
    }

    private class QueryFactoryImpl
    extends CompoundQueryFactory {
        public QueryFactoryImpl(String language) {
            this(null, language);
        }

        public QueryFactoryImpl(final Node node, final String language) {
            super(Arrays.asList(new QOMQueryFactory(new QueryObjectModelFactoryImpl(QueryManagerImpl.this.sessionContext.getSessionImpl()){

                @Override
                protected QueryObjectModel createQuery(QueryObjectModelTree qomTree) throws RepositoryException {
                    return QueryManagerImpl.this.searchMgr.createQueryObjectModel(QueryManagerImpl.this.sessionContext, qomTree, language, node);
                }
            }, QueryManagerImpl.this.sessionContext.getSessionImpl().getValueFactory()), new AQTQueryFactory(){

                @Override
                public Query createQuery(String statement, String language) throws RepositoryException {
                    return QueryManagerImpl.this.searchMgr.createQuery(QueryManagerImpl.this.sessionContext, statement, language, node);
                }
            }));
        }
    }
}

