/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.observation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.jcr.Session;
import javax.jcr.observation.EventListener;
import javax.jcr.observation.EventListenerIterator;
import org.apache.jackrabbit.core.observation.EventConsumer;

class EventListenerIteratorImpl
implements EventListenerIterator {
    private final Session session;
    private final Iterator<EventConsumer> consumers;
    private EventListener next;
    private long pos;

    EventListenerIteratorImpl(Session session, Collection<EventConsumer> sConsumers, Collection<EventConsumer> aConsumers) throws NullPointerException {
        if (session == null) {
            throw new NullPointerException("session");
        }
        if (sConsumers == null) {
            throw new NullPointerException("consumers");
        }
        if (aConsumers == null) {
            throw new NullPointerException("consumers");
        }
        this.session = session;
        ArrayList<EventConsumer> allConsumers = new ArrayList<EventConsumer>(sConsumers);
        allConsumers.addAll(aConsumers);
        this.consumers = allConsumers.iterator();
        this.fetchNext();
    }

    @Override
    public EventListener nextEventListener() {
        if (this.next == null) {
            throw new NoSuchElementException();
        }
        EventListener l = this.next;
        this.fetchNext();
        ++this.pos;
        return l;
    }

    @Override
    public void skip(long skipNum) {
        while (skipNum-- > 0L) {
            this.next();
        }
    }

    @Override
    public long getSize() {
        return -1L;
    }

    @Override
    public long getPosition() {
        return this.pos;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("EventListenerIterator.remove()");
    }

    @Override
    public boolean hasNext() {
        return this.next != null;
    }

    public Object next() {
        return this.nextEventListener();
    }

    private void fetchNext() {
        this.next = null;
        while (this.next == null && this.consumers.hasNext()) {
            EventConsumer consumer = this.consumers.next();
            if (!consumer.getSession().equals(this.session)) continue;
            this.next = consumer.getEventListener();
        }
    }
}

