/*
 * Decompiled with CFR 0.152.
 */
package com.epam.parso.impl;

import com.epam.parso.Column;
import com.epam.parso.SasFileProperties;
import com.epam.parso.SasFileReader;
import com.epam.parso.date.OutputDateType;
import com.epam.parso.impl.SasFileParser;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.NoSuchElementException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SasFileReaderImpl
implements SasFileReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(SasFileReaderImpl.class);
    private final SasFileParser sasFileParser;
    private final List<Column> columnsByName = new ArrayList<Column>();

    public SasFileReaderImpl(InputStream inputStream) {
        this.sasFileParser = new SasFileParser.Builder(inputStream).build();
    }

    public SasFileReaderImpl(InputStream inputStream, String encoding) {
        this.sasFileParser = new SasFileParser.Builder(inputStream).encoding(encoding).build();
    }

    public SasFileReaderImpl(InputStream inputStream, String encoding, OutputDateType outputDateType) {
        this.sasFileParser = new SasFileParser.Builder(inputStream).encoding(encoding).outputDateType(outputDateType).build();
    }

    public SasFileReaderImpl(InputStream inputStream, Boolean byteOutput) {
        this.sasFileParser = new SasFileParser.Builder(inputStream).byteOutput(byteOutput).build();
    }

    @Override
    public List<Column> getColumns() {
        return this.sasFileParser.getColumns();
    }

    @Override
    public List<Column> getColumns(List<String> columnNames) {
        if (this.columnsByName.isEmpty()) {
            HashMap<String, Column> columnsMap = new HashMap<String, Column>();
            List<Column> allColumns = this.sasFileParser.getColumns();
            for (Column column : allColumns) {
                columnsMap.put(column.getName(), column);
            }
            for (String name : columnNames) {
                if (columnsMap.containsKey(name)) {
                    this.columnsByName.add((Column)columnsMap.get(name));
                    continue;
                }
                throw new NoSuchElementException("Unknown column name");
            }
        }
        return this.columnsByName;
    }

    @Override
    public Object[][] readAll(List<String> columnNames) {
        int rowNum = (int)this.getSasFileProperties().getRowCount();
        Object[][] result = new Object[rowNum][];
        for (int i = 0; i < rowNum; ++i) {
            try {
                result[i] = this.readNext(columnNames);
                continue;
            }
            catch (IOException e) {
                if (!LOGGER.isWarnEnabled()) break;
                LOGGER.warn("I/O exception, skipping the rest of the file. Rows read: " + i + ". Expected number of rows from metadata: " + rowNum, e);
                break;
            }
        }
        return result;
    }

    @Override
    public Object[][] readAll() {
        return this.readAll(null);
    }

    @Override
    public Object[] readNext() throws IOException {
        return this.sasFileParser.readNext(null);
    }

    @Override
    public Object[] readNext(List<String> columnNames) throws IOException {
        return this.sasFileParser.readNext(columnNames);
    }

    @Override
    public Integer getOffset() {
        return this.sasFileParser.getOffset();
    }

    @Override
    public SasFileProperties getSasFileProperties() {
        return this.sasFileParser.getSasFileProperties();
    }
}

