/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.schemaengine.schemaregion.attribute.update;

import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.schemaengine.schemaregion.attribute.update.UpdateDetailContainer;

public class UpdateDetailContainerStatistics {
    private static final long MIN_DEGRADE_MEMORY = IoTDBDescriptor.getInstance().getConfig().getDetailContainerMinDegradeMemoryInBytes();
    private long lastUpdateTime = System.currentTimeMillis();
    private long entrySize = 0L;

    long getContainerSize() {
        return this.entrySize + UpdateDetailContainer.INSTANCE_SIZE;
    }

    void addEntrySize(long increment) {
        this.entrySize += increment;
    }

    void decreaseEntrySize(long decrement) {
        this.entrySize -= decrement;
        this.lastUpdateTime = System.currentTimeMillis();
    }

    boolean needDegrade() {
        return this.entrySize >= MIN_DEGRADE_MEMORY;
    }

    long getDegradePriority() {
        return this.entrySize * (System.currentTimeMillis() - this.lastUpdateTime);
    }
}

