/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.sql.ast;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.iotdb.db.exception.sql.SemanticException;
import org.apache.iotdb.db.queryengine.plan.relational.planner.ir.IrUtils;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ArithmeticBinaryExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ComparisonExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Expression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.JoinCriteria;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.JoinOn;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.LogicalExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.LongLiteral;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Node;
import org.apache.tsfile.utils.TimeDuration;

public class AsofJoinOn
extends JoinOn {
    private final Expression asofExpression;
    private static final String joinErrMsg = "The join expression of ASOF should be single Comparison or Logical 'AND'";
    private static final String asofErrMsg = "The main join expression of ASOF should only be Comparison '>, >=, <, <=', actual is %s";

    public AsofJoinOn(Expression otherExpression, Expression asofExpression) {
        super(otherExpression);
        this.asofExpression = asofExpression;
    }

    public Expression getAsofExpression() {
        return this.asofExpression;
    }

    public static JoinCriteria constructAsofJoinOn(Expression joinExpression, TimeDuration timeDuration) {
        ComparisonExpression asofExpression;
        ImmutableList.Builder newTerms = ImmutableList.builder();
        if (joinExpression instanceof ComparisonExpression) {
            asofExpression = (ComparisonExpression)joinExpression;
        } else if (joinExpression instanceof LogicalExpression) {
            LogicalExpression logicalExpression = (LogicalExpression)joinExpression;
            if (logicalExpression.getOperator() != LogicalExpression.Operator.AND) {
                throw new SemanticException(joinErrMsg);
            }
            List<Expression> terms = logicalExpression.getTerms();
            Expression lastExpression = (Expression)Iterables.getLast(terms);
            if (!(lastExpression instanceof ComparisonExpression)) {
                throw new SemanticException(String.format(asofErrMsg, lastExpression));
            }
            asofExpression = (ComparisonExpression)lastExpression;
            int size = terms.size() - 1;
            for (int i = 0; i < size; ++i) {
                newTerms.add((Object)terms.get(i));
            }
        } else {
            throw new SemanticException(joinErrMsg);
        }
        if (timeDuration != null) {
            LongLiteral timeInterval = new LongLiteral(String.valueOf(timeDuration.nonMonthDuration));
            switch (asofExpression.getOperator()) {
                case GREATER_THAN: 
                case GREATER_THAN_OR_EQUAL: {
                    newTerms.add((Object)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN_OR_EQUAL, asofExpression.getLeft(), new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.ADD, asofExpression.getRight(), timeInterval)));
                    break;
                }
                case LESS_THAN: 
                case LESS_THAN_OR_EQUAL: {
                    newTerms.add((Object)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN_OR_EQUAL, asofExpression.getRight(), new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.ADD, asofExpression.getLeft(), timeInterval)));
                    break;
                }
                default: {
                    throw new SemanticException(String.format(asofErrMsg, asofExpression));
                }
            }
        } else {
            switch (asofExpression.getOperator()) {
                case GREATER_THAN: 
                case GREATER_THAN_OR_EQUAL: 
                case LESS_THAN: 
                case LESS_THAN_OR_EQUAL: {
                    break;
                }
                default: {
                    throw new SemanticException(String.format(asofErrMsg, asofExpression));
                }
            }
        }
        ImmutableList newTermList = newTerms.build();
        if (newTermList.isEmpty()) {
            return new AsofJoinOn(null, asofExpression);
        }
        return new AsofJoinOn(IrUtils.and((Collection<Expression>)newTermList), asofExpression);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AsofJoinOn o = (AsofJoinOn)obj;
        return Objects.equals(this.expression, o.expression) && Objects.equals(this.asofExpression, o.asofExpression);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.expression, this.asofExpression);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).addValue((Object)this.expression).addValue((Object)this.asofExpression).toString();
    }

    @Override
    public List<Node> getNodes() {
        return ImmutableList.of((Object)this.expression, (Object)this.asofExpression);
    }
}

