/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.planner.node;

import com.google.common.collect.Iterables;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeType;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanVisitor;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.SingleChildProcessNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.Symbol;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class GapFillNode
extends SingleChildProcessNode {
    private final long startTime;
    private final long endTime;
    private final int monthDuration;
    private final long nonMonthDuration;
    private final Symbol gapFillColumn;
    private final List<Symbol> gapFillGroupingKeys;

    public GapFillNode(PlanNodeId id, PlanNode child, long startTime, long endTime, int monthDuration, long nonMonthDuration, Symbol gapFillColumn, @Nonnull List<Symbol> gapFillGroupingKeys) {
        super(id, child);
        this.startTime = startTime;
        this.endTime = endTime;
        this.monthDuration = monthDuration;
        this.nonMonthDuration = nonMonthDuration;
        this.gapFillColumn = gapFillColumn;
        this.gapFillGroupingKeys = gapFillGroupingKeys;
    }

    public Symbol getGapFillColumn() {
        return this.gapFillColumn;
    }

    public List<Symbol> getGapFillGroupingKeys() {
        return this.gapFillGroupingKeys;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public int getMonthDuration() {
        return this.monthDuration;
    }

    public long getNonMonthDuration() {
        return this.nonMonthDuration;
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitGapFill(this, context);
    }

    @Override
    public List<String> getOutputColumnNames() {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<Symbol> getOutputSymbols() {
        return this.child.getOutputSymbols();
    }

    @Override
    public PlanNode clone() {
        return new GapFillNode(this.id, null, this.startTime, this.endTime, this.monthDuration, this.nonMonthDuration, this.gapFillColumn, this.gapFillGroupingKeys);
    }

    @Override
    protected void serializeAttributes(ByteBuffer byteBuffer) {
        PlanNodeType.TABLE_GAP_FILL_NODE.serialize(byteBuffer);
        ReadWriteIOUtils.write((long)this.startTime, (ByteBuffer)byteBuffer);
        ReadWriteIOUtils.write((long)this.endTime, (ByteBuffer)byteBuffer);
        ReadWriteIOUtils.write((int)this.monthDuration, (ByteBuffer)byteBuffer);
        ReadWriteIOUtils.write((long)this.nonMonthDuration, (ByteBuffer)byteBuffer);
        Symbol.serialize(this.gapFillColumn, byteBuffer);
        ReadWriteIOUtils.write((int)this.gapFillGroupingKeys.size(), (ByteBuffer)byteBuffer);
        for (Symbol symbol : this.gapFillGroupingKeys) {
            Symbol.serialize(symbol, byteBuffer);
        }
    }

    @Override
    protected void serializeAttributes(DataOutputStream stream) throws IOException {
        PlanNodeType.TABLE_GAP_FILL_NODE.serialize(stream);
        ReadWriteIOUtils.write((long)this.startTime, (OutputStream)stream);
        ReadWriteIOUtils.write((long)this.endTime, (OutputStream)stream);
        ReadWriteIOUtils.write((int)this.monthDuration, (OutputStream)stream);
        ReadWriteIOUtils.write((long)this.nonMonthDuration, (OutputStream)stream);
        Symbol.serialize(this.gapFillColumn, stream);
        ReadWriteIOUtils.write((int)this.gapFillGroupingKeys.size(), (OutputStream)stream);
        for (Symbol symbol : this.gapFillGroupingKeys) {
            Symbol.serialize(symbol, stream);
        }
    }

    public static GapFillNode deserialize(ByteBuffer byteBuffer) {
        long startTime = ReadWriteIOUtils.readLong((ByteBuffer)byteBuffer);
        long endTime = ReadWriteIOUtils.readLong((ByteBuffer)byteBuffer);
        int monthDuration = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
        long nonMonthDuration = ReadWriteIOUtils.readLong((ByteBuffer)byteBuffer);
        Symbol gapFillColumn = Symbol.deserialize(byteBuffer);
        int size = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
        ArrayList<Symbol> gapFillGroupingKeys = new ArrayList<Symbol>(size);
        while (size-- > 0) {
            gapFillGroupingKeys.add(Symbol.deserialize(byteBuffer));
        }
        PlanNodeId planNodeId = PlanNodeId.deserialize(byteBuffer);
        return new GapFillNode(planNodeId, null, startTime, endTime, monthDuration, nonMonthDuration, gapFillColumn, gapFillGroupingKeys);
    }

    @Override
    public PlanNode replaceChildren(List<PlanNode> newChildren) {
        return new GapFillNode(this.id, (PlanNode)Iterables.getOnlyElement(newChildren), this.startTime, this.endTime, this.monthDuration, this.nonMonthDuration, this.gapFillColumn, this.gapFillGroupingKeys);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        GapFillNode that = (GapFillNode)o;
        return this.startTime == that.startTime && this.endTime == that.endTime && this.monthDuration == that.monthDuration && this.nonMonthDuration == that.nonMonthDuration && Objects.equals(this.gapFillColumn, that.gapFillColumn) && Objects.equals(this.gapFillGroupingKeys, that.gapFillGroupingKeys);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.startTime, this.endTime, this.monthDuration, this.nonMonthDuration, this.gapFillColumn, this.gapFillGroupingKeys);
    }

    public String toString() {
        return "GapFillNode-" + this.getPlanNodeId();
    }
}

