/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.transformation.dag.column.unary.scalar;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.concurrent.TimeUnit;
import org.apache.iotdb.db.queryengine.transformation.dag.column.ColumnTransformer;
import org.apache.iotdb.db.queryengine.transformation.dag.column.unary.UnaryColumnTransformer;
import org.apache.iotdb.db.utils.DateTimeUtils;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.block.column.ColumnBuilder;
import org.apache.tsfile.read.common.type.Type;

public class DateBinFunctionColumnTransformer
extends UnaryColumnTransformer {
    private static final long NANOSECONDS_IN_MILLISECOND = 1000000L;
    private static final long NANOSECONDS_IN_MICROSECOND = 1000L;
    private final int monthDuration;
    private final long nonMonthDuration;
    private final long origin;
    private final ZoneId zoneId;

    public DateBinFunctionColumnTransformer(Type returnType, long monthDuration, long nonMonthDuration, ColumnTransformer childColumnTransformer, long origin, ZoneId zoneId) {
        super(returnType, childColumnTransformer);
        this.monthDuration = (int)monthDuration;
        this.nonMonthDuration = nonMonthDuration;
        this.origin = origin;
        this.zoneId = zoneId;
    }

    private static LocalDateTime convertToLocalDateTime(long timestamp, ZoneId zoneId) {
        Instant instant;
        switch (DateTimeUtils.TIMESTAMP_PRECISION) {
            case "ms": {
                instant = Instant.ofEpochMilli(timestamp);
                break;
            }
            case "us": {
                instant = Instant.ofEpochSecond(TimeUnit.MICROSECONDS.toSeconds(timestamp), timestamp % 1000000L * 1000L);
                break;
            }
            case "ns": {
                instant = Instant.ofEpochSecond(TimeUnit.NANOSECONDS.toSeconds(timestamp), timestamp % 1000000000L);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported precision: " + DateTimeUtils.TIMESTAMP_PRECISION);
            }
        }
        return LocalDateTime.ofInstant(instant, zoneId);
    }

    private static long convertToTimestamp(LocalDateTime dateTime, ZoneId zoneId) {
        long epochMilliSecond = dateTime.atZone(zoneId).toInstant().toEpochMilli();
        long nanoAdjustment = dateTime.getNano();
        switch (DateTimeUtils.TIMESTAMP_PRECISION) {
            case "ms": {
                return epochMilliSecond + nanoAdjustment / 1000000L;
            }
            case "us": {
                return TimeUnit.MILLISECONDS.toMicros(epochMilliSecond) + nanoAdjustment / 1000L;
            }
            case "ns": {
                return TimeUnit.MILLISECONDS.toNanos(epochMilliSecond) + nanoAdjustment;
            }
        }
        throw new IllegalArgumentException("Unknown precision: " + DateTimeUtils.TIMESTAMP_PRECISION);
    }

    private static long getNanoTimeStamp(long timestamp) {
        switch (DateTimeUtils.TIMESTAMP_PRECISION) {
            case "ms": {
                return TimeUnit.MILLISECONDS.toNanos(timestamp);
            }
            case "us": {
                return TimeUnit.MICROSECONDS.toNanos(timestamp);
            }
            case "ns": {
                return timestamp;
            }
        }
        throw new IllegalArgumentException("Unknown precision: " + DateTimeUtils.TIMESTAMP_PRECISION);
    }

    public static long dateBin(long source, long origin, int monthDuration, long nonMonthDuration, ZoneId zoneId) {
        if (monthDuration == 0 && nonMonthDuration == 0L) {
            return source;
        }
        if (monthDuration != 0) {
            LocalDateTime sourceDate = DateBinFunctionColumnTransformer.convertToLocalDateTime(source, zoneId);
            LocalDateTime originDate = DateBinFunctionColumnTransformer.convertToLocalDateTime(origin, zoneId);
            long monthsDiff = ChronoUnit.MONTHS.between(originDate, sourceDate);
            long completedMonthCycles = monthsDiff / (long)monthDuration;
            LocalDateTime binStart = originDate.plusNanos(DateBinFunctionColumnTransformer.getNanoTimeStamp(nonMonthDuration) * completedMonthCycles).plusMonths(completedMonthCycles * (long)monthDuration);
            if (binStart.isAfter(sourceDate)) {
                binStart = binStart.minusMonths(monthDuration).minusNanos(DateBinFunctionColumnTransformer.getNanoTimeStamp(nonMonthDuration));
            }
            return DateBinFunctionColumnTransformer.convertToTimestamp(binStart, zoneId);
        }
        long diff = source - origin;
        long n = diff >= 0L ? diff / nonMonthDuration : (diff - nonMonthDuration + 1L) / nonMonthDuration;
        return origin + n * nonMonthDuration;
    }

    public long[] dateBinStartEnd(long source) {
        if (this.monthDuration == 0 && this.nonMonthDuration == 0L) {
            return new long[]{source, source};
        }
        if (this.monthDuration != 0) {
            LocalDateTime sourceDate = DateBinFunctionColumnTransformer.convertToLocalDateTime(source, this.zoneId);
            LocalDateTime originDate = DateBinFunctionColumnTransformer.convertToLocalDateTime(this.origin, this.zoneId);
            long monthsDiff = ChronoUnit.MONTHS.between(originDate, sourceDate);
            long completedMonthCycles = monthsDiff / (long)this.monthDuration;
            LocalDateTime binStart = originDate.plusNanos(DateBinFunctionColumnTransformer.getNanoTimeStamp(this.nonMonthDuration) * completedMonthCycles).plusMonths(completedMonthCycles * (long)this.monthDuration);
            if (binStart.isAfter(sourceDate)) {
                binStart = binStart.minusMonths(this.monthDuration).minusNanos(DateBinFunctionColumnTransformer.getNanoTimeStamp(this.nonMonthDuration));
            }
            return new long[]{DateBinFunctionColumnTransformer.convertToTimestamp(binStart, this.zoneId), DateBinFunctionColumnTransformer.convertToTimestamp(binStart.plusMonths(this.monthDuration), this.zoneId)};
        }
        long diff = source - this.origin;
        long n = diff >= 0L ? diff / this.nonMonthDuration : (diff - this.nonMonthDuration + 1L) / this.nonMonthDuration;
        return new long[]{this.origin + n * this.nonMonthDuration, this.origin + n * this.nonMonthDuration + this.nonMonthDuration};
    }

    public static long nextDateBin(int monthDuration, ZoneId zoneId, long currentTime) {
        LocalDateTime currentDateTime = DateBinFunctionColumnTransformer.convertToLocalDateTime(currentTime, zoneId);
        LocalDateTime nextDateTime = currentDateTime.plusMonths(monthDuration);
        return DateBinFunctionColumnTransformer.convertToTimestamp(nextDateTime, zoneId);
    }

    public static long nextDateBin(long nonMonthDuration, long currentTime) {
        return currentTime + nonMonthDuration;
    }

    @Override
    protected void doTransform(Column column, ColumnBuilder columnBuilder) {
        int n = column.getPositionCount();
        for (int i = 0; i < n; ++i) {
            if (!column.isNull(i)) {
                long result = DateBinFunctionColumnTransformer.dateBin(column.getLong(i), this.origin, this.monthDuration, this.nonMonthDuration, this.zoneId);
                columnBuilder.writeLong(result);
                continue;
            }
            columnBuilder.appendNull();
        }
    }

    @Override
    protected void doTransform(Column column, ColumnBuilder columnBuilder, boolean[] selection) {
        int n = column.getPositionCount();
        for (int i = 0; i < n; ++i) {
            if (selection[i] && !column.isNull(i)) {
                long result = DateBinFunctionColumnTransformer.dateBin(column.getLong(i), this.origin, this.monthDuration, this.nonMonthDuration, this.zoneId);
                columnBuilder.writeLong(result);
                continue;
            }
            columnBuilder.appendNull();
        }
    }
}

