/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.schedule;

import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.OptionalInt;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang3.StringUtils;
import org.apache.iotdb.commons.concurrent.ThreadName;
import org.apache.iotdb.commons.exception.StartupException;
import org.apache.iotdb.commons.service.IService;
import org.apache.iotdb.commons.service.ServiceType;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.queryengine.common.FragmentInstanceId;
import org.apache.iotdb.db.queryengine.common.QueryId;
import org.apache.iotdb.db.queryengine.common.SessionInfo;
import org.apache.iotdb.db.queryengine.exception.CpuNotEnoughException;
import org.apache.iotdb.db.queryengine.exception.MemoryNotEnoughException;
import org.apache.iotdb.db.queryengine.execution.driver.DataDriver;
import org.apache.iotdb.db.queryengine.execution.driver.IDriver;
import org.apache.iotdb.db.queryengine.execution.exchange.IMPPDataExchangeManager;
import org.apache.iotdb.db.queryengine.execution.exchange.MPPDataExchangeService;
import org.apache.iotdb.db.queryengine.execution.schedule.AbstractDriverThread;
import org.apache.iotdb.db.queryengine.execution.schedule.DriverTaskAbortedException;
import org.apache.iotdb.db.queryengine.execution.schedule.DriverTaskThread;
import org.apache.iotdb.db.queryengine.execution.schedule.DriverTaskTimeoutSentinelThread;
import org.apache.iotdb.db.queryengine.execution.schedule.ExecutionContext;
import org.apache.iotdb.db.queryengine.execution.schedule.IDriverScheduler;
import org.apache.iotdb.db.queryengine.execution.schedule.ITaskScheduler;
import org.apache.iotdb.db.queryengine.execution.schedule.ThreadProducer;
import org.apache.iotdb.db.queryengine.execution.schedule.queue.IndexedBlockingQueue;
import org.apache.iotdb.db.queryengine.execution.schedule.queue.IndexedBlockingReserveQueue;
import org.apache.iotdb.db.queryengine.execution.schedule.queue.L1PriorityQueue;
import org.apache.iotdb.db.queryengine.execution.schedule.queue.multilevelqueue.DriverTaskHandle;
import org.apache.iotdb.db.queryengine.execution.schedule.queue.multilevelqueue.MultilevelPriorityQueue;
import org.apache.iotdb.db.queryengine.execution.schedule.task.DriverTask;
import org.apache.iotdb.db.queryengine.execution.schedule.task.DriverTaskStatus;
import org.apache.iotdb.db.queryengine.metric.DriverSchedulerMetricSet;
import org.apache.iotdb.db.storageengine.rescon.quotas.DataNodeThrottleQuotaManager;
import org.apache.iotdb.db.utils.SetThreadName;
import org.apache.iotdb.mpp.rpc.thrift.TFragmentInstanceId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DriverScheduler
implements IDriverScheduler,
IService {
    private static final Logger logger = LoggerFactory.getLogger(DriverScheduler.class);
    private static final DriverSchedulerMetricSet DRIVER_SCHEDULER_METRIC_SET = DriverSchedulerMetricSet.getInstance();
    private static final IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    private static final double LEVEL_TIME_MULTIPLIER = 2.0;
    private final IndexedBlockingReserveQueue<DriverTask> readyQueue;
    private final IndexedBlockingQueue<DriverTask> timeoutQueue;
    private final Set<DriverTask> blockedTasks;
    private final Map<QueryId, Map<FragmentInstanceId, Set<DriverTask>>> queryMap;
    private final ITaskScheduler scheduler;
    private final AtomicInteger nextDriverTaskHandleId = new AtomicInteger(0);
    private IMPPDataExchangeManager blockManager;
    private static final int QUERY_MAX_CAPACITY = config.getMaxAllowedConcurrentQueries();
    private static final int WORKER_THREAD_NUM = config.getQueryThreadCount();
    private static final int TASK_MAX_CAPACITY = QUERY_MAX_CAPACITY * config.getDegreeOfParallelism();
    private static final long QUERY_TIMEOUT_MS = config.getQueryTimeoutThreshold();
    private final ThreadGroup workerGroups;
    private final List<AbstractDriverThread> threads;

    public static DriverScheduler getInstance() {
        return InstanceHolder.instance;
    }

    private DriverScheduler() {
        this.readyQueue = new MultilevelPriorityQueue(2.0, TASK_MAX_CAPACITY, new DriverTask());
        this.timeoutQueue = new L1PriorityQueue<DriverTask>(QUERY_MAX_CAPACITY, new DriverTask.TimeoutComparator(), new DriverTask());
        this.queryMap = new ConcurrentHashMap<QueryId, Map<FragmentInstanceId, Set<DriverTask>>>();
        this.blockedTasks = Collections.synchronizedSet(new HashSet());
        this.scheduler = new Scheduler();
        this.workerGroups = new ThreadGroup("ScheduleThreads");
        this.threads = new ArrayList<AbstractDriverThread>();
        this.blockManager = MPPDataExchangeService.getInstance().getMPPDataExchangeManager();
    }

    public void start() throws StartupException {
        for (int i = 0; i < WORKER_THREAD_NUM; ++i) {
            final int index = i;
            String threadName = ThreadName.QUERY_WORKER.getName() + "-" + i;
            ThreadProducer producer = new ThreadProducer(){

                @Override
                public void produce(String threadName, ThreadGroup workerGroups, IndexedBlockingQueue<DriverTask> queue, ThreadProducer producer) {
                    DriverTaskThread newThread = new DriverTaskThread(threadName, workerGroups, DriverScheduler.this.readyQueue, DriverScheduler.this.scheduler, this);
                    DriverScheduler.this.threads.set(index, newThread);
                    newThread.start();
                }
            };
            DriverTaskThread t = new DriverTaskThread(threadName, this.workerGroups, this.readyQueue, this.scheduler, producer);
            this.threads.add(t);
            t.start();
        }
        String threadName = ThreadName.QUERY_SENTINEL.getName();
        ThreadProducer producer = new ThreadProducer(){

            @Override
            public void produce(String threadName, ThreadGroup workerGroups, IndexedBlockingQueue<DriverTask> queue, ThreadProducer producer) {
                DriverTaskTimeoutSentinelThread newThread = new DriverTaskTimeoutSentinelThread(threadName, workerGroups, DriverScheduler.this.timeoutQueue, DriverScheduler.this.scheduler, this);
                DriverScheduler.this.threads.set(WORKER_THREAD_NUM, newThread);
                newThread.start();
            }
        };
        DriverTaskTimeoutSentinelThread t = new DriverTaskTimeoutSentinelThread(threadName, this.workerGroups, this.timeoutQueue, this.scheduler, producer);
        this.threads.add(t);
        t.start();
    }

    public void stop() {
        this.threads.forEach(t -> {
            try {
                t.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        });
    }

    public ServiceType getID() {
        return ServiceType.FRAGMENT_INSTANCE_MANAGER_SERVICE;
    }

    @Override
    public void submitDrivers(QueryId queryId, List<IDriver> drivers, long timeOut, SessionInfo sessionInfo) throws CpuNotEnoughException, MemoryNotEnoughException {
        DriverTaskHandle driverTaskHandle = new DriverTaskHandle(this.getNextDriverTaskHandleId(), (MultilevelPriorityQueue)this.readyQueue, OptionalInt.of(Integer.MAX_VALUE));
        ArrayList tasks = new ArrayList();
        drivers.forEach(driver -> tasks.add(new DriverTask((IDriver)driver, timeOut > 0L ? timeOut : QUERY_TIMEOUT_MS, DriverTaskStatus.READY, driverTaskHandle, driver.getEstimatedMemorySize(), driver.isHighestPriority())));
        ArrayList<DriverTask> submittedTasks = new ArrayList<DriverTask>();
        for (DriverTask task : tasks) {
            IDriver driver2 = task.getDriver();
            int dependencyDriverIndex = driver2.getDriverContext().getDependencyDriverIndex();
            if (dependencyDriverIndex != -1) {
                SettableFuture<Void> blockedDependencyFuture = ((DriverTask)tasks.get(dependencyDriverIndex)).getBlockedDependencyDriver();
                blockedDependencyFuture.addListener(() -> this.queryMap.computeIfPresent(queryId, (k1, queryRelatedTasks) -> {
                    queryRelatedTasks.computeIfPresent(task.getDriverTaskId().getFragmentInstanceId(), (k2, instanceRelatedTasks) -> {
                        instanceRelatedTasks.add(task);
                        this.submitTaskToReadyQueue(task);
                        return instanceRelatedTasks;
                    });
                    return queryRelatedTasks;
                }), MoreExecutors.directExecutor());
                continue;
            }
            submittedTasks.add(task);
        }
        if (IoTDBDescriptor.getInstance().getConfig().isQuotaEnable() && sessionInfo != null && !sessionInfo.getUserName().equals("root")) {
            AtomicInteger usedCpu = new AtomicInteger();
            AtomicLong estimatedMemory = new AtomicLong();
            this.queryMap.get(queryId).values().forEach(driverTasks -> driverTasks.forEach(driverTask -> {
                if (driverTask.getStatus().equals((Object)DriverTaskStatus.RUNNING) && driverTask.getDriver() instanceof DataDriver) {
                    usedCpu.addAndGet(1);
                    estimatedMemory.addAndGet(driverTask.getEstimatedMemorySize());
                }
            }));
            if (!DataNodeThrottleQuotaManager.getInstance().getThrottleQuotaLimit().checkCpu(sessionInfo.getUserName(), usedCpu.get())) {
                throw new CpuNotEnoughException("There is not enough cpu to execute current fragment instance");
            }
            if (!DataNodeThrottleQuotaManager.getInstance().getThrottleQuotaLimit().checkMemory(sessionInfo.getUserName(), estimatedMemory.get())) {
                throw new MemoryNotEnoughException("There is no enough memory to execute current fragment instance");
            }
        }
        for (DriverTask task : submittedTasks) {
            this.registerTaskToQueryMap(queryId, task);
        }
        this.scheduler.enforceTimeLimit((DriverTask)submittedTasks.get(submittedTasks.size() - 1));
        for (DriverTask task : submittedTasks) {
            this.submitTaskToReadyQueue(task);
        }
    }

    public void registerTaskToQueryMap(QueryId queryId, DriverTask driverTask) {
        this.queryMap.computeIfAbsent(queryId, k -> new ConcurrentHashMap()).computeIfAbsent(driverTask.getDriverTaskId().getFragmentInstanceId(), v -> Collections.synchronizedSet(new HashSet())).add(driverTask);
    }

    public void submitTaskToReadyQueue(DriverTask task) {
        task.lock();
        try {
            if (task.getStatus() != DriverTaskStatus.READY) {
                return;
            }
            this.readyQueue.push(task);
            task.setLastEnterReadyQueueTime(System.nanoTime());
        }
        finally {
            task.unlock();
        }
    }

    @Override
    public void abortQuery(QueryId queryId) {
        Map<FragmentInstanceId, Set<DriverTask>> queryRelatedTasks = this.queryMap.remove(queryId);
        if (queryRelatedTasks != null) {
            for (Set<DriverTask> fragmentRelatedTasks : queryRelatedTasks.values()) {
                if (fragmentRelatedTasks == null) continue;
                for (DriverTask task : fragmentRelatedTasks) {
                    task.setAbortCause("query cascading aborted");
                    this.clearDriverTask(task);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void abortFragmentInstance(FragmentInstanceId instanceId) {
        Set<DriverTask> instanceRelatedTasks;
        Map<FragmentInstanceId, Set<DriverTask>> queryRelatedTasks = this.queryMap.get(instanceId.getQueryId());
        if (queryRelatedTasks != null && (instanceRelatedTasks = queryRelatedTasks.remove(instanceId)) != null) {
            Set<DriverTask> set = instanceRelatedTasks;
            synchronized (set) {
                for (DriverTask task : instanceRelatedTasks) {
                    if (task == null) {
                        return;
                    }
                    task.setAbortCause(" called");
                    this.clearDriverTask(task);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void clearDriverTask(DriverTask task) {
        driverTaskName = new SetThreadName(task.getDriver().getDriverTaskId().getFullId());
        try {
            try {
                task.lock();
                status = task.getStatus();
                switch (3.$SwitchMap$org$apache$iotdb$db$queryengine$execution$schedule$task$DriverTaskStatus[status.ordinal()]) {
                    case 1: {
                        return;
                    }
                    case 2: {
                        task.setStatus(DriverTaskStatus.ABORTED);
                        this.readyQueue.remove((DriverTask)task.getDriverTaskId());
                        ** break;
lbl14:
                        // 1 sources

                        break;
                    }
                    case 3: {
                        task.setStatus(DriverTaskStatus.ABORTED);
                        this.blockedTasks.remove(task);
                        this.readyQueue.decreaseReservedSize();
                        ** break;
lbl21:
                        // 1 sources

                        break;
                    }
                    case 4: {
                        task.setStatus(DriverTaskStatus.ABORTED);
                        this.readyQueue.decreaseReservedSize();
                        ** break;
lbl26:
                        // 1 sources

                        break;
                    }
                    case 5: {
                        ** break;
lbl29:
                        // 1 sources

                        break;
                    }
                    default: {
                        task.setStatus(DriverTaskStatus.ABORTED);
                        break;
                    }
                }
            }
            finally {
                task.unlock();
            }
            this.timeoutQueue.remove((DriverTask)task.getDriverTaskId());
            queryRelatedTasks = this.queryMap.get(task.getDriverTaskId().getQueryId());
            if (queryRelatedTasks != null) {
                instanceRelatedTasks = queryRelatedTasks.get(task.getDriverTaskId().getFragmentInstanceId());
                if (instanceRelatedTasks != null) {
                    instanceRelatedTasks.remove(task);
                    if (instanceRelatedTasks.isEmpty()) {
                        queryRelatedTasks.remove(task.getDriverTaskId().getFragmentInstanceId());
                    }
                }
                if (queryRelatedTasks.isEmpty()) {
                    this.queryMap.remove(task.getDriverTaskId().getQueryId());
                }
            }
            try {
                task.lock();
                if (task.getAbortCause() != null) {
                    try {
                        task.getDriver().failed(new DriverTaskAbortedException(task.getDriver().getDriverTaskId().getFullId(), task.getAbortCause()));
                    }
                    catch (Exception e) {
                        DriverScheduler.logger.error("Clear DriverTask failed", (Throwable)e);
                    }
                }
                if (task.getStatus() == DriverTaskStatus.ABORTED) {
                    try {
                        this.blockManager.forceDeregisterFragmentInstance(new TFragmentInstanceId(task.getDriverTaskId().getQueryId().getId(), task.getDriverTaskId().getFragmentId().getId(), task.getDriverTaskId().getFragmentInstanceId().getInstanceId()));
                    }
                    catch (Exception e) {
                        DriverScheduler.logger.error("Clear DriverTask failed", (Throwable)e);
                    }
                }
            }
            finally {
                task.unlock();
            }
        }
        finally {
            driverTaskName.close();
        }
    }

    private int getNextDriverTaskHandleId() {
        return this.nextDriverTaskHandleId.getAndIncrement();
    }

    ITaskScheduler getScheduler() {
        return this.scheduler;
    }

    public long getReadyQueueTaskCount() {
        return this.readyQueue.size();
    }

    public long getBlockQueueTaskCount() {
        return this.blockedTasks.size();
    }

    public long getTimeoutQueueTaskCount() {
        return this.timeoutQueue.size();
    }

    public int getQueryMapSize() {
        return this.queryMap.size();
    }

    public IndexedBlockingQueue<DriverTask> getReadyQueue() {
        return this.readyQueue;
    }

    IndexedBlockingQueue<DriverTask> getTimeoutQueue() {
        return this.timeoutQueue;
    }

    Set<DriverTask> getBlockedTasks() {
        return this.blockedTasks;
    }

    Map<QueryId, Map<FragmentInstanceId, Set<DriverTask>>> getQueryMap() {
        return this.queryMap;
    }

    void setBlockManager(IMPPDataExchangeManager blockManager) {
        this.blockManager = blockManager;
    }

    private static class InstanceHolder {
        private static final DriverScheduler instance = new DriverScheduler();

        private InstanceHolder() {
        }
    }

    private class Scheduler
    implements ITaskScheduler {
        private Scheduler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void blockedToReady(DriverTask task) {
            task.lock();
            try {
                if (task.getStatus() != DriverTaskStatus.BLOCKED) {
                    return;
                }
                task.setStatus(DriverTaskStatus.READY);
                long currentTime = System.nanoTime();
                long blockQueuedTime = currentTime - task.getLastEnterBlockQueueTime();
                task.getDriver().getDriverContext().getFragmentInstanceContext().addBlockQueuedTime(blockQueuedTime);
                DRIVER_SCHEDULER_METRIC_SET.recordTaskQueueTime("block_queued_time", blockQueuedTime);
                task.setLastEnterReadyQueueTime(currentTime);
                task.resetLevelScheduledTime();
                DriverScheduler.this.readyQueue.repush(task);
                DriverScheduler.this.blockedTasks.remove(task);
            }
            finally {
                task.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean readyToRunning(DriverTask task) {
            task.lock();
            try {
                if (task.getStatus() != DriverTaskStatus.READY) {
                    boolean bl = false;
                    return bl;
                }
                task.setStatus(DriverTaskStatus.RUNNING);
                long readyQueuedTime = System.nanoTime() - task.getLastEnterReadyQueueTime();
                task.getDriver().getDriverContext().getFragmentInstanceContext().addReadyQueuedTime(readyQueuedTime);
                DRIVER_SCHEDULER_METRIC_SET.recordTaskQueueTime("ready_queued_time", readyQueuedTime);
            }
            finally {
                task.unlock();
            }
            return true;
        }

        @Override
        public void runningToReady(DriverTask task, ExecutionContext context) {
            task.lock();
            try {
                if (task.getStatus() != DriverTaskStatus.RUNNING) {
                    return;
                }
                task.updateSchedulePriority(context);
                task.setStatus(DriverTaskStatus.READY);
                task.setLastEnterReadyQueueTime(System.nanoTime());
                DriverScheduler.this.readyQueue.repush(task);
            }
            finally {
                task.unlock();
            }
        }

        @Override
        public void runningToBlocked(DriverTask task, ExecutionContext context) {
            task.lock();
            try {
                if (task.getStatus() != DriverTaskStatus.RUNNING) {
                    return;
                }
                task.updateSchedulePriority(context);
                task.setStatus(DriverTaskStatus.BLOCKED);
                task.setLastEnterBlockQueueTime(System.nanoTime());
                DriverScheduler.this.blockedTasks.add(task);
            }
            finally {
                task.unlock();
            }
        }

        @Override
        public void runningToFinished(DriverTask task, ExecutionContext context) {
            task.lock();
            try {
                if (task.getStatus() != DriverTaskStatus.RUNNING) {
                    return;
                }
                task.updateSchedulePriority(context);
                task.setStatus(DriverTaskStatus.FINISHED);
                DriverScheduler.this.readyQueue.decreaseReservedSize();
            }
            finally {
                task.unlock();
            }
            DriverScheduler.this.clearDriverTask(task);
        }

        @Override
        public void enforceTimeLimit(DriverTask task) {
            DriverScheduler.this.timeoutQueue.push(task);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void toAborted(DriverTask task) {
            try (SetThreadName driverTaskName = new SetThreadName(task.getDriver().getDriverTaskId().getFullId());){
                task.lock();
                try {
                    if (task.isEndState()) {
                        return;
                    }
                    logger.warn("The task {} is aborted. All other tasks in the same query will be cancelled", (Object)task.getDriverTaskId());
                }
                finally {
                    task.unlock();
                }
                DriverScheduler.this.clearDriverTask(task);
                String abortCause = task.getAbortCause();
                QueryId queryId = task.getDriverTaskId().getQueryId();
                Map queryRelatedTasks = (Map)DriverScheduler.this.queryMap.remove(queryId);
                if (queryRelatedTasks == null) return;
                Iterator iterator = queryRelatedTasks.values().iterator();
                while (iterator.hasNext()) {
                    Set fragmentRelatedTasks = (Set)iterator.next();
                    if (fragmentRelatedTasks == null) continue;
                    Set set = fragmentRelatedTasks;
                    synchronized (set) {
                        for (DriverTask otherTask : fragmentRelatedTasks) {
                            if (task.equals(otherTask)) continue;
                            otherTask.setAbortCause(StringUtils.isEmpty((CharSequence)abortCause) ? "query cascading aborted" : abortCause);
                            DriverScheduler.this.clearDriverTask(otherTask);
                        }
                    }
                }
                return;
            }
        }
    }
}

