/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.nodes.filters;

import java.util.function.BiConsumer;
import java.util.function.Function;
import org.eclipse.milo.opcua.sdk.server.nodes.filters.AttributeFilter;
import org.eclipse.milo.opcua.sdk.server.nodes.filters.AttributeFilterContext;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;

public final class AttributeFilters {
    private AttributeFilters() {
    }

    public static AttributeFilter getValue(final Function<AttributeFilterContext.GetAttributeContext, DataValue> get) {
        return new AttributeFilter(){

            @Override
            public Object getAttribute(AttributeFilterContext.GetAttributeContext ctx, AttributeId attributeId) {
                if (attributeId == AttributeId.Value) {
                    return get.apply(ctx);
                }
                return ctx.getAttribute(attributeId);
            }
        };
    }

    public static AttributeFilter setValue(final BiConsumer<AttributeFilterContext.SetAttributeContext, DataValue> set) {
        return new AttributeFilter(){

            @Override
            public void setAttribute(AttributeFilterContext.SetAttributeContext ctx, AttributeId attributeId, Object value) {
                if (attributeId == AttributeId.Value) {
                    set.accept(ctx, (DataValue)value);
                } else {
                    ctx.setAttribute(attributeId, value);
                }
            }
        };
    }
}

