/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.analyze.cache.schema.dualkeycache.impl;

import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import org.apache.iotdb.db.queryengine.plan.analyze.cache.schema.dualkeycache.impl.ICacheEntry;
import org.apache.iotdb.db.queryengine.plan.analyze.cache.schema.dualkeycache.impl.ICacheEntryGroup;

public class CacheEntryGroupImpl<FK, SK, V, T extends ICacheEntry<SK, V>>
implements ICacheEntryGroup<FK, SK, V, T> {
    private final FK firstKey;
    private final Map<SK, T> cacheEntryMap = new ConcurrentHashMap<SK, T>();

    CacheEntryGroupImpl(FK firstKey) {
        this.firstKey = firstKey;
    }

    @Override
    public FK getFirstKey() {
        return this.firstKey;
    }

    @Override
    public T getCacheEntry(SK secondKey) {
        return (T)(secondKey == null ? null : (ICacheEntry)this.cacheEntryMap.get(secondKey));
    }

    @Override
    public Iterator<Map.Entry<SK, T>> getAllCacheEntries() {
        return this.cacheEntryMap.entrySet().iterator();
    }

    @Override
    public T computeCacheEntry(SK secondKey, BiFunction<SK, T, T> computation) {
        return (T)((ICacheEntry)this.cacheEntryMap.compute(secondKey, computation));
    }

    @Override
    public T removeCacheEntry(SK secondKey) {
        return (T)((ICacheEntry)this.cacheEntryMap.remove(secondKey));
    }

    @Override
    public boolean isEmpty() {
        return this.cacheEntryMap.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CacheEntryGroupImpl that = (CacheEntryGroupImpl)o;
        return Objects.equals(this.firstKey, that.firstKey);
    }

    public int hashCode() {
        return this.firstKey.hashCode();
    }
}

