/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.service.quarkus.auth;

import io.quarkus.security.AuthenticationFailedException;
import io.quarkus.security.identity.AuthenticationRequestContext;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.security.identity.SecurityIdentityAugmentor;
import io.quarkus.security.runtime.QuarkusSecurityIdentity;
import io.smallrye.mutiny.Uni;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.security.Principal;
import org.apache.iceberg.exceptions.NotAuthorizedException;
import org.apache.polaris.core.auth.AuthenticatedPolarisPrincipal;
import org.apache.polaris.service.auth.Authenticator;
import org.apache.polaris.service.auth.PrincipalAuthInfo;
import org.apache.polaris.service.quarkus.auth.QuarkusPrincipalAuthInfo;

@ApplicationScoped
public class AuthenticatingAugmentor
implements SecurityIdentityAugmentor {
    public static final int PRIORITY = 1000;
    private final Authenticator<PrincipalAuthInfo, AuthenticatedPolarisPrincipal> authenticator;

    @Inject
    public AuthenticatingAugmentor(Authenticator<PrincipalAuthInfo, AuthenticatedPolarisPrincipal> authenticator) {
        this.authenticator = authenticator;
    }

    public int priority() {
        return 1000;
    }

    public Uni<SecurityIdentity> augment(SecurityIdentity identity, AuthenticationRequestContext context) {
        if (identity.isAnonymous()) {
            return Uni.createFrom().item((Object)identity);
        }
        PrincipalAuthInfo authInfo = this.extractPrincipalAuthInfo(identity);
        return context.runBlocking(() -> this.authenticatePolarisPrincipal(identity, authInfo));
    }

    private PrincipalAuthInfo extractPrincipalAuthInfo(SecurityIdentity identity) {
        QuarkusPrincipalAuthInfo credential = (QuarkusPrincipalAuthInfo)identity.getCredential(QuarkusPrincipalAuthInfo.class);
        if (credential == null) {
            throw new AuthenticationFailedException("No token credential available");
        }
        return credential;
    }

    private SecurityIdentity authenticatePolarisPrincipal(SecurityIdentity identity, PrincipalAuthInfo authInfo) {
        try {
            AuthenticatedPolarisPrincipal polarisPrincipal = (AuthenticatedPolarisPrincipal)this.authenticator.authenticate((Object)authInfo).orElseThrow(() -> new NotAuthorizedException("Authentication failed", new Object[0]));
            return QuarkusSecurityIdentity.builder((SecurityIdentity)identity).setPrincipal((Principal)polarisPrincipal).build();
        }
        catch (RuntimeException e) {
            throw new AuthenticationFailedException((Throwable)e);
        }
    }
}

