/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.core.config;

import com.google.common.base.Preconditions;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.polaris.core.config.PolarisConfiguration;
import org.apache.polaris.core.context.RealmContext;
import org.apache.polaris.core.entity.CatalogEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface PolarisConfigurationStore {
    public static final Logger LOGGER = LoggerFactory.getLogger(PolarisConfigurationStore.class);

    @Nullable
    default public <T> T getConfiguration(@Nonnull RealmContext realmContext, String configName) {
        return null;
    }

    @Nonnull
    default public <T> T getConfiguration(@Nonnull RealmContext realmContext, String configName, @Nonnull T defaultValue) {
        Preconditions.checkNotNull(defaultValue, (Object)"Cannot pass null as a default value");
        T configValue = this.getConfiguration(realmContext, configName);
        return configValue != null ? configValue : defaultValue;
    }

    @Nonnull
    private <T> T tryCast(PolarisConfiguration<T> config, Object value) {
        if (value == null) {
            return config.defaultValue;
        }
        if (config.defaultValue instanceof Boolean) {
            return config.cast(Boolean.valueOf(String.valueOf(value)));
        }
        if (config.defaultValue instanceof Integer) {
            return config.cast(Integer.valueOf(String.valueOf(value)));
        }
        if (config.defaultValue instanceof Long) {
            return config.cast(Long.valueOf(String.valueOf(value)));
        }
        if (config.defaultValue instanceof Double) {
            return config.cast(Double.valueOf(String.valueOf(value)));
        }
        if (config.defaultValue instanceof List) {
            return config.cast(new ArrayList((List)value));
        }
        return config.cast(value);
    }

    @Nonnull
    default public <T> T getConfiguration(@Nonnull RealmContext realmContext, PolarisConfiguration<T> config) {
        Object result = this.getConfiguration(realmContext, config.key, config.defaultValue);
        return this.tryCast(config, result);
    }

    @Nonnull
    default public <T> T getConfiguration(@Nonnull RealmContext realmContext, @Nonnull CatalogEntity catalogEntity, PolarisConfiguration<T> config) {
        if (config.hasCatalogConfig() || config.hasCatalogConfigUnsafe()) {
            Map<String, String> propertiesMap = catalogEntity.getPropertiesAsMap();
            String propertyValue = null;
            if (config.hasCatalogConfig()) {
                propertyValue = propertiesMap.get(config.catalogConfig());
            }
            if (propertyValue == null) {
                if (config.hasCatalogConfigUnsafe()) {
                    propertyValue = propertiesMap.get(config.catalogConfigUnsafe());
                }
                if (propertyValue != null) {
                    LOGGER.warn(String.format("Deprecated config %s is in use and will be removed in a future version", config.catalogConfigUnsafe()));
                }
            }
            if (propertyValue != null) {
                return this.tryCast(config, propertyValue);
            }
        }
        return this.getConfiguration(realmContext, config);
    }
}

