/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http.rest;

import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpRequest;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.rest.Response;
import com.azure.core.implementation.serializer.HttpResponseDecoder;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import reactor.core.publisher.Mono;

final class ResponseConstructorsCache {
    private static final String THREE_PARAM_ERROR = "Failed to deserialize 3-parameter response.";
    private static final String FOUR_PARAM_ERROR = "Failed to deserialize 4-parameter response.";
    private static final String FIVE_PARAM_ERROR = "Failed to deserialize 5-parameter response.";
    private static final String INVALID_PARAM_COUNT = "Response constructor with expected parameters not found.";
    private final ClientLogger logger = new ClientLogger(ResponseConstructorsCache.class);
    private final Map<Class<?>, Constructor<? extends Response<?>>> cache = new ConcurrentHashMap();

    ResponseConstructorsCache() {
    }

    Constructor<? extends Response<?>> get(Class<? extends Response<?>> responseClass) {
        return this.cache.computeIfAbsent(responseClass, this::locateResponseConstructor);
    }

    private Constructor<? extends Response<?>> locateResponseConstructor(Class<?> responseClass) {
        Constructor<?>[] constructors = responseClass.getDeclaredConstructors();
        Arrays.sort(constructors, Comparator.comparing(Constructor::getParameterCount, (a, b) -> b - a));
        for (Constructor<?> constructor : constructors) {
            int paramCount = constructor.getParameterCount();
            if (paramCount < 3 || paramCount > 5) continue;
            try {
                return constructor;
            }
            catch (Throwable t) {
                throw this.logger.logExceptionAsError(new RuntimeException(t));
            }
        }
        return null;
    }

    Mono<Response<?>> invoke(Constructor<? extends Response<?>> constructor, HttpResponseDecoder.HttpDecodedResponse decodedResponse, Object bodyAsObject) {
        HttpResponse httpResponse = decodedResponse.getSourceResponse();
        HttpRequest httpRequest = httpResponse.getRequest();
        int responseStatusCode = httpResponse.getStatusCode();
        HttpHeaders responseHeaders = httpResponse.getHeaders();
        int paramCount = constructor.getParameterCount();
        switch (paramCount) {
            case 3: {
                return ResponseConstructorsCache.constructResponse(constructor, THREE_PARAM_ERROR, this.logger, httpRequest, responseStatusCode, responseHeaders);
            }
            case 4: {
                return ResponseConstructorsCache.constructResponse(constructor, FOUR_PARAM_ERROR, this.logger, httpRequest, responseStatusCode, responseHeaders, bodyAsObject);
            }
            case 5: {
                return ResponseConstructorsCache.constructResponse(constructor, FIVE_PARAM_ERROR, this.logger, httpRequest, responseStatusCode, responseHeaders, bodyAsObject, decodedResponse.getDecodedHeaders());
            }
        }
        return FluxUtil.monoError(this.logger, new IllegalStateException(INVALID_PARAM_COUNT));
    }

    private static Mono<Response<?>> constructResponse(Constructor<? extends Response<?>> constructor, String exceptionMessage, ClientLogger logger, Object ... params) {
        return Mono.fromCallable(() -> (Response)constructor.newInstance(params)).onErrorMap(ex -> logger.logExceptionAsError(new RuntimeException(exceptionMessage, (Throwable)ex)));
    }
}

