/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.migrationtools.tablemanagement;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite3.internal.client.table.ClientSchema;
import org.apache.ignite3.internal.client.table.ClientTable;

public class SchemaUtils {
    private static final Method GET_LATEST_SCHEMA_METHOD;

    private SchemaUtils() {
    }

    public static CompletableFuture<ClientSchema> getLatestSchemaForTable(ClientTable clientTable) {
        try {
            return (CompletableFuture)GET_LATEST_SCHEMA_METHOD.invoke((Object)clientTable, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            return CompletableFuture.failedFuture(e);
        }
    }

    static {
        try {
            GET_LATEST_SCHEMA_METHOD = ClientTable.class.getDeclaredMethod("getLatestSchema", new Class[0]);
            GET_LATEST_SCHEMA_METHOD.setAccessible(true);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }
}

