/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.services;

import java.util.HashMap;
import java.util.Map;
import org.apache.ignite.internal.processors.service.ServiceCallContextImpl;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.lang.IgniteExperimental;
import org.apache.ignite.services.ServiceCallContext;

@IgniteExperimental
public class ServiceCallContextBuilder {
    private final Map<String, Object> attrs = new HashMap<String, Object>();

    public ServiceCallContextBuilder put(String name, String value) {
        A.notNullOrEmpty(name, "name");
        A.notNull(value, "value");
        this.attrs.put(name, value);
        return this;
    }

    public ServiceCallContextBuilder put(String name, byte[] value) {
        A.notNullOrEmpty(name, "name");
        A.notNull(value, "value");
        this.attrs.put(name, value);
        return this;
    }

    public ServiceCallContext build() {
        if (this.attrs.isEmpty()) {
            throw new IllegalStateException("Cannot create an empty context.");
        }
        return new ServiceCallContextImpl(new HashMap<String, Object>(this.attrs));
    }
}

