/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.task.monitor;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.ignite.internal.GridTaskSessionImpl;
import org.apache.ignite.internal.processors.task.monitor.ComputeTaskStatusEnum;
import org.apache.ignite.internal.processors.task.monitor.ComputeTaskStatusSnapshot;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteUuid;
import org.jetbrains.annotations.Nullable;

public class ComputeTaskStatus
implements ComputeTaskStatusSnapshot {
    private final IgniteUuid sessionId;
    private final ComputeTaskStatusEnum status;
    private final String taskName;
    private final UUID originatingNodeId;
    private final long startTime;
    private final long endTime;
    private final List<UUID> jobNodes;
    private final Map<?, ?> attributes;
    @Nullable
    private final Throwable failReason;
    private final boolean fullSupport;
    @Nullable
    private Object createdBy;
    private final boolean internal;

    private ComputeTaskStatus(IgniteUuid sessionId, ComputeTaskStatusEnum status, String taskName, UUID originatingNodeId, long startTime, long endTime, List<UUID> jobNodes, Map<?, ?> attributes, @Nullable Throwable failReason, boolean fullSupport, @Nullable Object createdBy, boolean internal) {
        this.sessionId = sessionId;
        this.status = status;
        this.taskName = taskName;
        this.originatingNodeId = originatingNodeId;
        this.startTime = startTime;
        this.endTime = endTime;
        this.jobNodes = F.isEmpty(jobNodes) ? Collections.emptyList() : jobNodes;
        this.attributes = F.isEmpty(attributes) ? Collections.emptyMap() : attributes;
        this.failReason = failReason;
        this.fullSupport = fullSupport;
        this.createdBy = createdBy;
        this.internal = internal;
    }

    @Override
    public IgniteUuid sessionId() {
        return this.sessionId;
    }

    @Override
    public String taskName() {
        return this.taskName;
    }

    @Override
    public UUID originatingNodeId() {
        return this.originatingNodeId;
    }

    @Override
    public long startTime() {
        return this.startTime;
    }

    @Override
    public long endTime() {
        return this.endTime;
    }

    @Override
    public List<UUID> jobNodes() {
        return this.jobNodes;
    }

    @Override
    public Map<?, ?> attributes() {
        return this.attributes;
    }

    @Override
    public ComputeTaskStatusEnum status() {
        return this.status;
    }

    @Override
    @Nullable
    public Throwable failReason() {
        return this.failReason;
    }

    @Override
    public boolean fullSupport() {
        return this.fullSupport;
    }

    @Override
    @Nullable
    public Object createBy() {
        return this.createdBy;
    }

    @Override
    public boolean internal() {
        return this.internal;
    }

    public static ComputeTaskStatus snapshot(GridTaskSessionImpl sessionImp) {
        return new ComputeTaskStatus(sessionImp.getId(), ComputeTaskStatusEnum.RUNNING, sessionImp.getTaskName(), sessionImp.getTaskNodeId(), sessionImp.getStartTime(), 0L, sessionImp.jobNodesSafeCopy(), sessionImp.attributesSafeCopy(), null, sessionImp.isFullSupport(), sessionImp.login(), sessionImp.isInternal());
    }

    public static ComputeTaskStatus onFinishTask(GridTaskSessionImpl sessionImp, @Nullable Throwable err) {
        return new ComputeTaskStatus(sessionImp.getId(), err == null ? ComputeTaskStatusEnum.FINISHED : ComputeTaskStatusEnum.FAILED, sessionImp.getTaskName(), sessionImp.getTaskNodeId(), sessionImp.getStartTime(), U.currentTimeMillis(), sessionImp.jobNodesSafeCopy(), sessionImp.attributesSafeCopy(), err, sessionImp.isFullSupport(), sessionImp.login(), sessionImp.isInternal());
    }
}

