/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.platform.client.service;

import java.util.Collections;
import java.util.Map;
import java.util.UUID;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.binary.BinaryRawReader;
import org.apache.ignite.internal.processors.platform.client.ClientConnectionContext;
import org.apache.ignite.internal.processors.platform.client.ClientRequest;
import org.apache.ignite.internal.processors.platform.client.ClientResponse;
import org.apache.ignite.internal.processors.platform.client.IgniteClientException;
import org.apache.ignite.internal.processors.platform.client.service.ClientServiceMappingsResponse;
import org.apache.ignite.internal.util.typedef.F;

public class ClientServiceTopologyRequest
extends ClientRequest {
    private final String name;

    public ClientServiceTopologyRequest(BinaryRawReader reader) {
        super(reader);
        this.name = reader.readString();
    }

    @Override
    public ClientResponse process(ClientConnectionContext ctx) {
        Map<UUID, Integer> srvcTop;
        try {
            srvcTop = ctx.kernalContext().service().serviceTopology(this.name, 0L);
        }
        catch (IgniteCheckedException e) {
            throw new IgniteClientException(1, "Failed to get topology for service '" + this.name + "'.", e);
        }
        return new ClientServiceMappingsResponse(this.requestId(), F.isEmpty(srvcTop) ? Collections.emptyList() : srvcTop.keySet());
    }
}

