/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.platform.client.cache;

import java.util.ArrayList;
import java.util.Arrays;
import javax.cache.Cache;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteException;
import org.apache.ignite.binary.BinaryObject;
import org.apache.ignite.cache.query.IndexQuery;
import org.apache.ignite.cache.query.IndexQueryCriterion;
import org.apache.ignite.cache.query.QueryCursor;
import org.apache.ignite.internal.binary.BinaryRawReaderEx;
import org.apache.ignite.internal.cache.query.InIndexQueryCriterion;
import org.apache.ignite.internal.cache.query.RangeIndexQueryCriterion;
import org.apache.ignite.internal.processors.platform.client.ClientBitmaskFeature;
import org.apache.ignite.internal.processors.platform.client.ClientConnectionContext;
import org.apache.ignite.internal.processors.platform.client.ClientProtocolContext;
import org.apache.ignite.internal.processors.platform.client.ClientResponse;
import org.apache.ignite.internal.processors.platform.client.cache.ClientCacheEntryQueryCursor;
import org.apache.ignite.internal.processors.platform.client.cache.ClientCacheQueryRequest;
import org.apache.ignite.internal.processors.platform.client.cache.ClientCacheQueryResponse;
import org.apache.ignite.lang.IgniteBiPredicate;

public class ClientCacheIndexQueryRequest
extends ClientCacheQueryRequest {
    private final IndexQuery qry;
    private final int pageSize;

    public ClientCacheIndexQueryRequest(BinaryRawReaderEx reader, ClientProtocolContext protocolCtx) {
        super(reader);
        this.pageSize = reader.readInt();
        boolean loc = reader.readBoolean();
        int part = reader.readInt();
        int limit = 0;
        if (protocolCtx.isFeatureSupported(ClientBitmaskFeature.INDEX_QUERY_LIMIT)) {
            limit = reader.readInt();
        }
        String valType = reader.readString();
        String idxName = reader.readString();
        byte arrMark = reader.readByte();
        ArrayList<IndexQueryCriterion> criteria = null;
        if (arrMark == 1) {
            int critSize = reader.readInt();
            criteria = new ArrayList<IndexQueryCriterion>(critSize);
            for (int i = 0; i < critSize; ++i) {
                criteria.add(this.readCriterion(reader));
            }
        }
        Object filterObj = reader.readObjectDetached();
        this.qry = new IndexQuery(valType, idxName);
        this.qry.setPageSize(this.pageSize);
        this.qry.setLocal(loc);
        if (part >= 0) {
            this.qry.setPartition(part);
        }
        if (criteria != null) {
            this.qry.setCriteria(Arrays.asList(criteria.toArray()));
        }
        if (filterObj != null) {
            this.qry.setFilter((IgniteBiPredicate)((BinaryObject)filterObj).deserialize());
        }
        if (limit > 0) {
            this.qry.setLimit(limit);
        }
    }

    private IndexQueryCriterion readCriterion(BinaryRawReaderEx reader) {
        byte type = reader.readByte();
        if (type == 0) {
            return this.readRangeCriterion(reader);
        }
        if (type == 1) {
            return this.readInCriterion(reader);
        }
        throw new IgniteException("Unknown IndexQuery criterion type: " + type);
    }

    private IndexQueryCriterion readRangeCriterion(BinaryRawReaderEx reader) {
        String field = reader.readString();
        boolean lowerIncl = reader.readBoolean();
        boolean upperIncl = reader.readBoolean();
        boolean lowerNull = reader.readBoolean();
        boolean upperNull = reader.readBoolean();
        Object lower = reader.readObjectDetached();
        Object upper = reader.readObjectDetached();
        RangeIndexQueryCriterion r = new RangeIndexQueryCriterion(field, lower, upper);
        r.lowerIncl(lowerIncl);
        r.upperIncl(upperIncl);
        r.lowerNull(lowerNull);
        r.upperNull(upperNull);
        return r;
    }

    private IndexQueryCriterion readInCriterion(BinaryRawReaderEx reader) {
        String field = reader.readString();
        int valsCnt = reader.readInt();
        ArrayList vals = new ArrayList(valsCnt);
        for (int i = 0; i < valsCnt; ++i) {
            vals.add(reader.readObject());
        }
        return new InIndexQueryCriterion(field, vals);
    }

    @Override
    public ClientResponse process(ClientConnectionContext ctx) {
        IgniteCache<Object, Object> cache;
        IgniteCache<Object, Object> igniteCache = cache = this.qry.getFilter() != null && !this.isKeepBinary() ? this.rawCache(ctx) : this.cache(ctx);
        if (this.qry.getPartition() != null) {
            this.updateAffinityMetrics(ctx, this.qry.getPartition());
        }
        ctx.incrementCursors();
        try {
            QueryCursor<Cache.Entry> cur = cache.query(this.qry);
            ClientCacheEntryQueryCursor cliCur = new ClientCacheEntryQueryCursor(cur, this.pageSize, ctx);
            long cursorId = ctx.resources().put(cliCur);
            cliCur.id(cursorId);
            return new ClientCacheQueryResponse(this.requestId(), cliCur);
        }
        catch (Exception e) {
            ctx.decrementCursors();
            throw e;
        }
    }
}

