/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.wal.io;

import java.io.FileNotFoundException;
import java.io.IOException;
import org.apache.ignite.internal.processors.cache.persistence.file.FileIO;
import org.apache.ignite.internal.processors.cache.persistence.wal.ByteBufferExpander;
import org.apache.ignite.internal.processors.cache.persistence.wal.aware.SegmentAware;
import org.apache.ignite.internal.processors.cache.persistence.wal.io.SegmentIO;
import org.apache.ignite.internal.processors.cache.persistence.wal.io.SimpleFileInput;

final class LockedReadFileInput
extends SimpleFileInput {
    private final long segmentId;
    private final SegmentAware segmentAware;
    private final SegmentIoFactory fileIOFactory;
    private boolean isLastReadFromArchive;

    LockedReadFileInput(ByteBufferExpander buf, SegmentIO initFileIo, SegmentAware segmentAware, SegmentIoFactory segmentIOFactory) throws IOException {
        super(initFileIo, buf);
        this.segmentAware = segmentAware;
        this.fileIOFactory = segmentIOFactory;
        this.segmentId = initFileIo.getSegmentId();
        this.isLastReadFromArchive = segmentAware.lastArchivedAbsoluteIndex() >= initFileIo.getSegmentId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void ensure(int requested) throws IOException {
        int available = this.buffer().remaining();
        if (available >= requested) {
            return;
        }
        if (!this.segmentAware.reserve(this.segmentId)) {
            throw new FileNotFoundException("Segment does not exist: " + this.segmentId);
        }
        try {
            boolean readArchive = !this.segmentAware.lock(this.segmentId);
            try {
                if (readArchive && !this.isLastReadFromArchive) {
                    this.isLastReadFromArchive = true;
                    this.refreshIO();
                }
                super.ensure(requested);
            }
            finally {
                if (!readArchive) {
                    this.segmentAware.unlock(this.segmentId);
                }
            }
        }
        finally {
            this.segmentAware.release(this.segmentId);
        }
    }

    private void refreshIO() throws IOException {
        FileIO io = this.fileIOFactory.build(this.segmentId);
        io.position(this.io().position());
        this.io().close();
        this.io = io;
    }

    static interface SegmentIoFactory {
        public FileIO build(long var1) throws IOException;
    }
}

