/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.defragmentation;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.ignite.IgniteCheckedException;

public interface IgniteDefragmentation {
    public ScheduleResult schedule(List<String> var1) throws IgniteCheckedException;

    public CancelResult cancel() throws IgniteCheckedException;

    public DefragmentationStatus status() throws IgniteCheckedException;

    public boolean inProgress();

    public int processedPartitions();

    public int totalPartitions();

    public long startTime();

    public static class InProgressDefragmentationInfo
    extends DefragmentationInfo {
        int processedPartitions;
        int totalPartitions;

        public InProgressDefragmentationInfo(long elapsedTime, int processedPartitions, int totalPartitions) {
            super(elapsedTime);
            this.processedPartitions = processedPartitions;
            this.totalPartitions = totalPartitions;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("partitions processed/all: ").append(this.processedPartitions).append("/").append(this.totalPartitions);
            sb.append(", time elapsed: ");
            this.appendDuration(sb, this.elapsedTime);
            return sb.toString();
        }

        public int getProcessedPartitions() {
            return this.processedPartitions;
        }

        public int getTotalPartitions() {
            return this.totalPartitions;
        }
    }

    public static class CompletedDefragmentationInfo
    extends DefragmentationInfo {
        private static final DecimalFormat MB_FORMAT = new DecimalFormat("#.##", DecimalFormatSymbols.getInstance(Locale.US));
        long sizeBefore;
        long sizeAfter;

        public CompletedDefragmentationInfo(long elapsedTime, long sizeBefore, long sizeAfter) {
            super(elapsedTime);
            this.sizeBefore = sizeBefore;
            this.sizeAfter = sizeAfter;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            double mb = 1048576.0;
            sb.append("size before/after: ").append(MB_FORMAT.format((double)this.sizeBefore / mb)).append("MB/");
            sb.append(MB_FORMAT.format((double)this.sizeAfter / mb)).append("MB");
            sb.append(", time took: ");
            this.appendDuration(sb, this.elapsedTime);
            return sb.toString();
        }

        public long getSizeBefore() {
            return this.sizeBefore;
        }

        public long getSizeAfter() {
            return this.sizeAfter;
        }
    }

    public static abstract class DefragmentationInfo {
        long elapsedTime;

        public DefragmentationInfo(long elapsedTime) {
            this.elapsedTime = elapsedTime;
        }

        void appendDuration(StringBuilder sb, long elapsedTime) {
            long duration = Math.round((double)elapsedTime * 0.001);
            long mins = duration / 60L;
            long secs = duration % 60L;
            sb.append(mins).append(" mins ").append(secs).append(" secs");
        }

        public long getElapsedTime() {
            return this.elapsedTime;
        }
    }

    public static class DefragmentationStatus {
        private final Map<String, CompletedDefragmentationInfo> completedCaches;
        private final Map<String, InProgressDefragmentationInfo> inProgressCaches;
        private final Set<String> awaitingCaches;
        private final Set<String> skippedCaches;
        private final int totalPartitions;
        private final int processedPartitions;
        private final long startTs;
        private final long totalElapsedTime;

        public DefragmentationStatus(Map<String, CompletedDefragmentationInfo> completedCaches, Map<String, InProgressDefragmentationInfo> inProgressCaches, Set<String> awaitingCaches, Set<String> skippedCaches, int totalPartitions, int processedPartitions, long startTs, long totalElapsedTime) {
            this.completedCaches = completedCaches;
            this.inProgressCaches = inProgressCaches;
            this.awaitingCaches = awaitingCaches;
            this.skippedCaches = skippedCaches;
            this.totalPartitions = totalPartitions;
            this.processedPartitions = processedPartitions;
            this.startTs = startTs;
            this.totalElapsedTime = totalElapsedTime;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            if (!this.completedCaches.isEmpty()) {
                sb.append("Defragmentation is completed for cache groups:\n");
                for (Map.Entry<String, CompletedDefragmentationInfo> entry : this.completedCaches.entrySet()) {
                    sb.append("    ").append(entry.getKey()).append(" - ");
                    sb.append(entry.getValue().toString()).append('\n');
                }
            }
            if (!this.inProgressCaches.isEmpty()) {
                sb.append("Defragmentation is in progress for cache groups:\n");
                for (Map.Entry<String, DefragmentationInfo> entry : this.inProgressCaches.entrySet()) {
                    sb.append("    ").append(entry.getKey()).append(" - ");
                    sb.append(((InProgressDefragmentationInfo)entry.getValue()).toString()).append('\n');
                }
            }
            if (!this.skippedCaches.isEmpty()) {
                sb.append("Skipped cache groups: ").append(String.join((CharSequence)", ", this.skippedCaches)).append('\n');
            }
            if (!this.awaitingCaches.isEmpty()) {
                sb.append("Awaiting defragmentation: ").append(String.join((CharSequence)", ", this.awaitingCaches)).append('\n');
            }
            return sb.toString();
        }

        public Map<String, CompletedDefragmentationInfo> getCompletedCaches() {
            return this.completedCaches;
        }

        public Map<String, InProgressDefragmentationInfo> getInProgressCaches() {
            return this.inProgressCaches;
        }

        public Set<String> getAwaitingCaches() {
            return this.awaitingCaches;
        }

        public Set<String> getSkippedCaches() {
            return this.skippedCaches;
        }

        public long getTotalElapsedTime() {
            return this.totalElapsedTime;
        }

        public int getTotalPartitions() {
            return this.totalPartitions;
        }

        public int getProcessedPartitions() {
            return this.processedPartitions;
        }

        public long getStartTs() {
            return this.startTs;
        }
    }

    public static enum CancelResult {
        CANCELLED_SCHEDULED,
        SCHEDULED_NOT_FOUND,
        CANCELLED,
        COMPLETED_OR_CANCELLED;

    }

    public static enum ScheduleResult {
        SUCCESS,
        SUCCESS_SUPERSEDED_PREVIOUS;

    }
}

