/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.pagemem.wal.record.delta;

import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.pagemem.PageMemory;
import org.apache.ignite.internal.pagemem.wal.record.WALRecord;
import org.apache.ignite.internal.pagemem.wal.record.delta.PageDeltaRecord;
import org.apache.ignite.internal.processors.cache.persistence.freelist.io.PagesListNodeIO;
import org.apache.ignite.internal.util.typedef.internal.S;

public class PagesListSetNextRecord
extends PageDeltaRecord {
    private final long nextPageId;

    public PagesListSetNextRecord(int grpId, long pageId, long nextPageId) {
        super(grpId, pageId);
        this.nextPageId = nextPageId;
    }

    public long nextPageId() {
        return this.nextPageId;
    }

    @Override
    public void applyDelta(PageMemory pageMem, long pageAddr) throws IgniteCheckedException {
        PagesListNodeIO io = PagesListNodeIO.VERSIONS.forPage(pageAddr);
        io.setNextId(pageAddr, this.nextPageId);
    }

    @Override
    public WALRecord.RecordType type() {
        return WALRecord.RecordType.PAGES_LIST_SET_NEXT;
    }

    @Override
    public String toString() {
        return S.toString(PagesListSetNextRecord.class, this, "super", (Object)super.toString());
    }
}

