/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.pagemem.wal.record;

import org.apache.ignite.binary.BinaryObject;
import org.apache.ignite.internal.pagemem.wal.record.DataEntry;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.CacheObjectValueContext;
import org.apache.ignite.internal.processors.cache.GridCacheOperation;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.SB;

public class UnwrapDataEntry
extends DataEntry {
    private final CacheObjectValueContext cacheObjValCtx;
    private final boolean keepBinary;

    public UnwrapDataEntry(int cacheId, KeyCacheObject key, CacheObject val, GridCacheOperation op, GridCacheVersion nearXidVer, GridCacheVersion writeVer, long expireTime, int partId, long partCnt, CacheObjectValueContext cacheObjValCtx, boolean keepBinary, byte flags) {
        super(cacheId, key, val, op, nearXidVer, writeVer, expireTime, partId, partCnt, flags);
        this.cacheObjValCtx = cacheObjValCtx;
        this.keepBinary = keepBinary;
    }

    public Object unwrappedKey() {
        try {
            return UnwrapDataEntry.unwrapKey(this.key, this.keepBinary, this.cacheObjValCtx);
        }
        catch (Exception e) {
            this.cacheObjValCtx.kernalContext().log(UnwrapDataEntry.class).error("Unable to convert key [" + this.key + "]", e);
            return null;
        }
    }

    public Object unwrappedValue() {
        try {
            return UnwrapDataEntry.unwrapValue(this.val, this.keepBinary, this.cacheObjValCtx);
        }
        catch (Exception e) {
            this.cacheObjValCtx.kernalContext().log(UnwrapDataEntry.class).error("Unable to convert value [" + this.value() + "]", e);
            return null;
        }
    }

    public static Object unwrapKey(KeyCacheObject key, boolean keepBinary, CacheObjectValueContext cacheObjValCtx) {
        if (keepBinary && key instanceof BinaryObject) {
            return key;
        }
        Object unwrapped = key.value(cacheObjValCtx, false);
        if (unwrapped instanceof BinaryObject) {
            if (keepBinary) {
                return unwrapped;
            }
            unwrapped = ((BinaryObject)unwrapped).deserialize();
        }
        return unwrapped;
    }

    public static Object unwrapValue(CacheObject val, boolean keepBinary, CacheObjectValueContext cacheObjValCtx) {
        if (val == null) {
            return null;
        }
        if (keepBinary && val instanceof BinaryObject) {
            return val;
        }
        return val.value(cacheObjValCtx, false);
    }

    @Override
    public String toString() {
        SB sb = new SB();
        sb.a(this.getClass().getSimpleName()).a('[');
        if (S.includeSensitive()) {
            sb.a("k = ").a(this.unwrappedKey()).a(", v = [ ").a(this.unwrappedValue()).a("], ");
        }
        return sb.a("super = [").a(super.toString()).a("]]").toString();
    }
}

