/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.pagemem.wal.record;

import java.io.DataInput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.apache.ignite.internal.pagemem.wal.record.WALRecord;
import org.apache.ignite.internal.util.typedef.internal.S;

public class IndexRenameRootPageRecord
extends WALRecord {
    private final int cacheId;
    private final String oldTreeName;
    private final String newTreeName;
    private final int segments;

    public IndexRenameRootPageRecord(int cacheId, String oldTreeName, String newTreeName, int segments) {
        this.cacheId = cacheId;
        this.oldTreeName = oldTreeName;
        this.newTreeName = newTreeName;
        this.segments = segments;
    }

    public IndexRenameRootPageRecord(DataInput in) throws IOException {
        this.cacheId = in.readInt();
        this.segments = in.readInt();
        byte[] oldTreeNameBytes = new byte[in.readInt()];
        in.readFully(oldTreeNameBytes);
        this.oldTreeName = new String(oldTreeNameBytes, StandardCharsets.UTF_8);
        byte[] newTreeNameBytes = new byte[in.readInt()];
        in.readFully(newTreeNameBytes);
        this.newTreeName = new String(newTreeNameBytes, StandardCharsets.UTF_8);
    }

    @Override
    public WALRecord.RecordType type() {
        return WALRecord.RecordType.INDEX_ROOT_PAGE_RENAME_RECORD;
    }

    public int cacheId() {
        return this.cacheId;
    }

    public String oldTreeName() {
        return this.oldTreeName;
    }

    public String newTreeName() {
        return this.newTreeName;
    }

    public int segments() {
        return this.segments;
    }

    public int dataSize() {
        return 12 + this.oldTreeName.getBytes(StandardCharsets.UTF_8).length + 4 + this.newTreeName.getBytes(StandardCharsets.UTF_8).length;
    }

    public void writeRecord(ByteBuffer buf) {
        buf.putInt(this.cacheId);
        buf.putInt(this.segments);
        byte[] oldTreeNameBytes = this.oldTreeName.getBytes(StandardCharsets.UTF_8);
        buf.putInt(oldTreeNameBytes.length);
        buf.put(oldTreeNameBytes);
        byte[] newTreeNameBytes = this.newTreeName.getBytes(StandardCharsets.UTF_8);
        buf.putInt(newTreeNameBytes.length);
        buf.put(newTreeNameBytes);
    }

    @Override
    public String toString() {
        return S.toString(IndexRenameRootPageRecord.class, this);
    }
}

