/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.management.metric;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.ignite.internal.management.api.Argument;
import org.apache.ignite.internal.management.api.Positional;
import org.apache.ignite.internal.management.metric.MetricCommandArg;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;

public class MetricConfigureHistogramCommandArg
extends MetricCommandArg {
    private static final long serialVersionUID = 0L;
    @Argument(description="Comma-separated list of longs to configure histogram", example="newBounds")
    @Positional
    private long[] newBounds;

    @Override
    protected void writeExternalData(ObjectOutput out) throws IOException {
        super.writeExternalData(out);
        U.writeLongArray(out, this.newBounds);
    }

    @Override
    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternalData(protoVer, in);
        this.newBounds = U.readLongArray(in);
    }

    public long[] newBounds() {
        return this.newBounds;
    }

    public void newBounds(long[] bounds) {
        if (!F.isSorted(bounds)) {
            throw new IllegalArgumentException("Bounds must be sorted");
        }
        this.newBounds = bounds;
    }
}

