/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.management.consistency;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.ignite.cache.ReadRepairStrategy;
import org.apache.ignite.internal.dto.IgniteDataTransferObject;
import org.apache.ignite.internal.management.api.Argument;
import org.apache.ignite.internal.management.api.EnumDescription;
import org.apache.ignite.internal.util.typedef.internal.U;

public class ConsistencyRepairCommandArg
extends IgniteDataTransferObject {
    private static final long serialVersionUID = 0L;
    @Argument(description="Cache to be checked/repaired")
    private String cache;
    @Argument(description="Cache's partition to be checked/repaired", example="partition")
    private int[] partitions;
    @Argument(description="Repair strategy")
    @EnumDescription(names={"LWW", "PRIMARY", "RELATIVE_MAJORITY", "REMOVE", "CHECK_ONLY"}, descriptions={"Last write (the newest entry) wins", "Value from the primary node wins", "The relative majority, any value found more times than any other wins", "Inconsistent entries will be removed", "Only check will be performed"})
    ReadRepairStrategy strategy;
    @Argument(description="Run concurrently on each node", optional=true)
    private boolean parallel;

    public void ensureParams() {
        if (this.parallel && this.strategy != ReadRepairStrategy.CHECK_ONLY) {
            throw new UnsupportedOperationException("Parallel mode currently allowed only when CHECK_ONLY strategy is chosen.");
        }
    }

    @Override
    protected void writeExternalData(ObjectOutput out) throws IOException {
        U.writeString(out, this.cache);
        U.writeIntArray(out, this.partitions);
        U.writeEnum(out, this.strategy);
        out.writeBoolean(this.parallel);
    }

    @Override
    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        this.cache = U.readString(in);
        this.partitions = U.readIntArray(in);
        this.strategy = U.readEnum(in, ReadRepairStrategy.class);
        this.parallel = in.readBoolean();
    }

    public int[] partitions() {
        return this.partitions;
    }

    public void partitions(int[] partition) {
        this.partitions = partition;
    }

    public String cache() {
        return this.cache;
    }

    public void cache(String cacheName) {
        this.cache = cacheName;
    }

    public ReadRepairStrategy strategy() {
        return this.strategy;
    }

    public void strategy(ReadRepairStrategy strategy) {
        this.strategy = strategy;
        this.ensureParams();
    }

    public boolean parallel() {
        return this.parallel;
    }

    public void parallel(boolean parallel) {
        this.parallel = parallel;
        this.ensureParams();
    }
}

