/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.binary;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.binary.BinaryObjectException;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.binary.BinaryContext;
import org.apache.ignite.internal.binary.GridBinaryMarshaller;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.marshaller.AbstractNodeNameAwareMarshaller;
import org.jetbrains.annotations.Nullable;
import sun.misc.Unsafe;

public class BinaryMarshaller
extends AbstractNodeNameAwareMarshaller {
    @GridToStringExclude
    private GridBinaryMarshaller impl;

    public static boolean available() {
        try {
            Class<Unsafe> unsafeCls = Unsafe.class;
            unsafeCls.getMethod("allocateInstance", Class.class);
            unsafeCls.getMethod("copyMemory", Object.class, Long.TYPE, Object.class, Long.TYPE, Long.TYPE);
            return true;
        }
        catch (Exception ignored) {
            return false;
        }
        catch (NoClassDefFoundError ignored) {
            return false;
        }
    }

    public void setBinaryContext(BinaryContext ctx, IgniteConfiguration cfg) {
        ctx.configure(this, cfg != null ? cfg.getBinaryConfiguration() : null);
        this.impl = new GridBinaryMarshaller(ctx);
    }

    @Override
    protected byte[] marshal0(@Nullable Object obj) throws IgniteCheckedException {
        return this.impl.marshal(obj, false);
    }

    @Override
    protected void marshal0(@Nullable Object obj, OutputStream out) throws IgniteCheckedException {
        byte[] arr = this.marshal(obj);
        try {
            out.write(arr);
        }
        catch (Exception e) {
            throw new BinaryObjectException("Failed to marshal the object: " + obj, e);
        }
    }

    @Override
    protected <T> T unmarshal0(byte[] bytes, @Nullable ClassLoader clsLdr) {
        return this.impl.deserialize(bytes, clsLdr);
    }

    @Override
    protected <T> T unmarshal0(InputStream in, @Nullable ClassLoader clsLdr) throws IgniteCheckedException {
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        try {
            int cnt;
            byte[] arr = new byte[4096];
            while ((cnt = in.read(arr)) != -1) {
                buf.write(arr, 0, cnt);
            }
            buf.flush();
            return this.impl.deserialize(buf.toByteArray(), clsLdr);
        }
        catch (IOException e) {
            throw new BinaryObjectException("Failed to unmarshal the object from InputStream", e);
        }
    }

    @Override
    public void onUndeploy(ClassLoader ldr) {
        this.impl.context().onUndeploy(ldr);
    }

    public GridBinaryMarshaller binaryMarshaller() {
        return this.impl;
    }

    public String toString() {
        return S.toString(BinaryMarshaller.class, this);
    }
}

