/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite;

import java.io.InputStream;
import java.net.URL;
import java.security.AccessController;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteIllegalStateException;
import org.apache.ignite.IgniteState;
import org.apache.ignite.IgnitionListener;
import org.apache.ignite.client.ClientException;
import org.apache.ignite.client.IgniteClient;
import org.apache.ignite.configuration.ClientConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgnitionEx;
import org.apache.ignite.internal.client.thin.TcpIgniteClient;
import org.apache.ignite.internal.processors.security.SecurityUtils;
import org.apache.ignite.internal.processors.security.sandbox.SandboxIgniteComponentProxy;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.jetbrains.annotations.Nullable;

public class Ignition {
    public static final int RESTART_EXIT_CODE = 250;
    public static final int KILL_EXIT_CODE = 130;

    protected Ignition() {
    }

    public static void setClientMode(boolean clientMode) {
        IgnitionEx.setClientMode(clientMode);
    }

    public static boolean isClientMode() {
        return IgnitionEx.isClientMode();
    }

    public static IgniteState state() {
        return IgnitionEx.state();
    }

    public static IgniteState state(@Nullable String name) {
        return IgnitionEx.state(name);
    }

    public static boolean stop(boolean cancel) {
        return IgnitionEx.stop(cancel, null);
    }

    public static boolean stop(String name, boolean cancel) {
        return IgnitionEx.stop(name, cancel, null, false);
    }

    public static void stopAll(boolean cancel) {
        IgnitionEx.stopAll(cancel, null);
    }

    public static void restart(boolean cancel) {
        IgnitionEx.restart(cancel);
    }

    public static void kill(boolean cancel) {
        IgnitionEx.kill(cancel);
    }

    public static Ignite start() throws IgniteException {
        try {
            return Ignition.wrapToProxyIfNeeded(IgnitionEx.start());
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
    }

    public static Ignite start(IgniteConfiguration cfg) throws IgniteException {
        try {
            return Ignition.wrapToProxyIfNeeded(IgnitionEx.start(cfg));
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
    }

    public static Ignite start(String springCfgPath) throws IgniteException {
        try {
            return Ignition.wrapToProxyIfNeeded(IgnitionEx.start(springCfgPath));
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
    }

    public static Ignite start(URL springCfgUrl) throws IgniteException {
        try {
            return Ignition.wrapToProxyIfNeeded(IgnitionEx.start(springCfgUrl));
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
    }

    public static Ignite start(InputStream springCfgStream) throws IgniteException {
        try {
            return Ignition.wrapToProxyIfNeeded(IgnitionEx.start(springCfgStream));
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
    }

    public static Ignite getOrStart(IgniteConfiguration cfg) throws IgniteException {
        try {
            return Ignition.wrapToProxyIfNeeded(IgnitionEx.start(cfg, false));
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
    }

    public static <T> T loadSpringBean(String springXmlPath, String beanName) throws IgniteException {
        try {
            return IgnitionEx.loadSpringBean(springXmlPath, beanName);
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
    }

    public static <T> T loadSpringBean(URL springXmlUrl, String beanName) throws IgniteException {
        try {
            return IgnitionEx.loadSpringBean(springXmlUrl, beanName);
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
    }

    public static <T> T loadSpringBean(InputStream springXmlStream, String beanName) throws IgniteException {
        try {
            return IgnitionEx.loadSpringBean(springXmlStream, beanName);
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
    }

    public static Ignite ignite() throws IgniteIllegalStateException {
        return Ignition.wrapToProxyIfNeeded(IgnitionEx.grid());
    }

    public static List<Ignite> allGrids() {
        List<Ignite> res = IgnitionEx.allGrids();
        if (F.isEmpty(res)) {
            return res;
        }
        if (SecurityUtils.isInsideSandbox()) {
            return res.stream().map(Ignition::wrapToProxy).collect(Collectors.toList());
        }
        return res;
    }

    public static Ignite ignite(UUID locNodeId) throws IgniteIllegalStateException {
        return Ignition.wrapToProxyIfNeeded(IgnitionEx.grid(locNodeId));
    }

    public static Ignite ignite(@Nullable String name) throws IgniteIllegalStateException {
        return Ignition.wrapToProxyIfNeeded(IgnitionEx.grid(name));
    }

    public static Ignite localIgnite() throws IgniteIllegalStateException, IllegalArgumentException {
        return Ignition.wrapToProxyIfNeeded(IgnitionEx.localIgnite());
    }

    private static Ignite wrapToProxy(Ignite ignite) {
        return AccessController.doPrivileged(() -> SandboxIgniteComponentProxy.igniteProxy(ignite));
    }

    private static Ignite wrapToProxyIfNeeded(Ignite ignite) {
        return SecurityUtils.isInsideSandbox() ? Ignition.wrapToProxy(ignite) : ignite;
    }

    public static void addListener(IgnitionListener lsnr) {
        IgnitionEx.addListener(lsnr);
    }

    public static boolean removeListener(IgnitionListener lsnr) {
        return IgnitionEx.removeListener(lsnr);
    }

    public static IgniteClient startClient(ClientConfiguration cfg) throws ClientException {
        Objects.requireNonNull(cfg, "cfg");
        return TcpIgniteClient.start(cfg);
    }
}

