/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.raft.jraft.util;

import java.util.Locale;
import org.apache.ignite3.internal.logger.IgniteLogger;
import org.apache.ignite3.internal.logger.Loggers;
import org.apache.ignite3.raft.jraft.util.SystemPropertyUtil;

public class Platform {
    private static final IgniteLogger LOG = Loggers.forClass(Platform.class);
    private static final boolean IS_WINDOWS = Platform.isWindows0();
    private static final boolean IS_MAC = Platform.isMac0();
    private static final boolean IS_LINUX = Platform.isLinux0();

    public static boolean isWindows() {
        return IS_WINDOWS;
    }

    public static boolean isMac() {
        return IS_MAC;
    }

    public static boolean isLinux() {
        return IS_LINUX;
    }

    private static boolean isMac0() {
        boolean mac = SystemPropertyUtil.get("os.name", "").toLowerCase(Locale.US).contains("mac os x");
        if (mac) {
            LOG.debug("Platform: Mac OS X", new Object[0]);
        }
        return mac;
    }

    private static boolean isWindows0() {
        boolean windows = SystemPropertyUtil.get("os.name", "").toLowerCase(Locale.US).contains("win");
        if (windows) {
            LOG.debug("Platform: Windows", new Object[0]);
        }
        return windows;
    }

    private static boolean isLinux0() {
        boolean linux = SystemPropertyUtil.get("os.name", "").toLowerCase(Locale.US).contains("linux");
        if (linux) {
            LOG.debug("Platform: Linux", new Object[0]);
        }
        return linux;
    }
}

