/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.raft.jraft.storage.snapshot.local;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.ignite3.internal.logger.IgniteLogger;
import org.apache.ignite3.internal.logger.Loggers;
import org.apache.ignite3.raft.jraft.entity.LocalFileMetaOutter;
import org.apache.ignite3.raft.jraft.entity.LocalSnapshotPbMetaBuilder;
import org.apache.ignite3.raft.jraft.entity.LocalStorageOutter;
import org.apache.ignite3.raft.jraft.entity.RaftOutter;
import org.apache.ignite3.raft.jraft.option.RaftOptions;
import org.apache.ignite3.raft.jraft.storage.io.MessageFile;
import org.apache.ignite3.raft.jraft.util.JDKMarshaller;

public class LocalSnapshotMetaTable {
    private static final IgniteLogger LOG = Loggers.forClass(LocalSnapshotMetaTable.class);
    private final Map<String, LocalFileMetaOutter.LocalFileMeta> fileMap = new HashMap<String, LocalFileMetaOutter.LocalFileMeta>();
    private final RaftOptions raftOptions;
    private RaftOutter.SnapshotMeta meta;

    public LocalSnapshotMetaTable(RaftOptions raftOptions) {
        this.raftOptions = raftOptions;
    }

    public ByteBuffer saveToByteBufferAsRemote() {
        LocalSnapshotPbMetaBuilder pbMetaBuilder = this.raftOptions.getRaftMessagesFactory().localSnapshotPbMeta();
        if (this.hasMeta()) {
            pbMetaBuilder.meta(this.meta);
        }
        List<LocalStorageOutter.LocalSnapshotPbMeta.File> files = this.fileMap.entrySet().stream().map(e -> this.raftOptions.getRaftMessagesFactory().file().name((String)e.getKey()).meta((LocalFileMetaOutter.LocalFileMeta)e.getValue()).build()).collect(Collectors.toList());
        pbMetaBuilder.filesList(files);
        return ByteBuffer.wrap(JDKMarshaller.INSTANCE.marshall(pbMetaBuilder.build()));
    }

    public boolean loadFromIoBufferAsRemote(ByteBuffer buf) {
        if (buf == null) {
            LOG.error("Null buf to load.", new Object[0]);
            return false;
        }
        try {
            LocalStorageOutter.LocalSnapshotPbMeta pbMeta = (LocalStorageOutter.LocalSnapshotPbMeta)JDKMarshaller.INSTANCE.unmarshall(buf);
            if (pbMeta == null) {
                LOG.error("Fail to load meta from buffer.", new Object[0]);
                return false;
            }
            return this.loadFromPbMeta(pbMeta);
        }
        catch (Exception e) {
            LOG.error("Fail to parse LocalSnapshotPbMeta from byte buffer", (Throwable)e);
            return false;
        }
    }

    public boolean addFile(String fileName, LocalFileMetaOutter.LocalFileMeta meta) {
        return this.fileMap.putIfAbsent(fileName, meta) == null;
    }

    public boolean removeFile(String fileName) {
        return this.fileMap.remove(fileName) != null;
    }

    public boolean saveToFile(String path) throws IOException {
        LocalSnapshotPbMetaBuilder pbMeta = this.raftOptions.getRaftMessagesFactory().localSnapshotPbMeta();
        if (this.hasMeta()) {
            pbMeta.meta(this.meta);
        }
        List<LocalStorageOutter.LocalSnapshotPbMeta.File> files = this.fileMap.entrySet().stream().map(e -> this.raftOptions.getRaftMessagesFactory().file().name((String)e.getKey()).meta((LocalFileMetaOutter.LocalFileMeta)e.getValue()).build()).collect(Collectors.toList());
        pbMeta.filesList(files);
        MessageFile pbFile = new MessageFile(path);
        return pbFile.save(pbMeta.build(), this.raftOptions.isSyncMeta());
    }

    public boolean hasMeta() {
        return this.meta != null;
    }

    public LocalFileMetaOutter.LocalFileMeta getFileMeta(String fileName) {
        return this.fileMap.get(fileName);
    }

    public Set<String> listFiles() {
        return this.fileMap.keySet();
    }

    public void setMeta(RaftOutter.SnapshotMeta meta) {
        this.meta = meta;
    }

    public RaftOutter.SnapshotMeta getMeta() {
        return this.meta;
    }

    public boolean loadFromFile(String path) throws IOException {
        MessageFile pbFile = new MessageFile(path);
        LocalStorageOutter.LocalSnapshotPbMeta pbMeta = (LocalStorageOutter.LocalSnapshotPbMeta)pbFile.load();
        if (pbMeta == null) {
            LOG.error("Fail to load meta from {}.", path);
            return false;
        }
        return this.loadFromPbMeta(pbMeta);
    }

    private boolean loadFromPbMeta(LocalStorageOutter.LocalSnapshotPbMeta pbMeta) {
        this.meta = pbMeta.meta() != null ? pbMeta.meta() : null;
        this.fileMap.clear();
        for (LocalStorageOutter.LocalSnapshotPbMeta.File f : pbMeta.filesList()) {
            this.fileMap.put(f.name(), f.meta());
        }
        return true;
    }
}

