/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.utils;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite3.internal.distributionzones.rebalance.RebalanceUtil;
import org.apache.ignite3.internal.lang.ByteArray;
import org.apache.ignite3.internal.metastorage.Entry;
import org.apache.ignite3.internal.metastorage.MetaStorageManager;
import org.apache.ignite3.internal.metastorage.WatchEvent;
import org.apache.ignite3.internal.metastorage.dsl.CompoundCondition;
import org.apache.ignite3.internal.metastorage.dsl.Condition;
import org.apache.ignite3.internal.metastorage.dsl.Conditions;
import org.apache.ignite3.internal.metastorage.dsl.Iif;
import org.apache.ignite3.internal.metastorage.dsl.Operation;
import org.apache.ignite3.internal.metastorage.dsl.Operations;
import org.apache.ignite3.internal.metastorage.dsl.Statements;
import org.apache.ignite3.internal.partitiondistribution.Assignment;
import org.apache.ignite3.internal.partitiondistribution.Assignments;
import org.apache.ignite3.internal.partitiondistribution.AssignmentsQueue;
import org.apache.ignite3.internal.partitiondistribution.PartitionDistributionUtils;
import org.apache.ignite3.internal.replicator.TablePartitionId;
import org.apache.ignite3.internal.util.ByteUtils;
import org.apache.ignite3.internal.util.CollectionUtils;
import org.apache.ignite3.internal.util.CompletableFutures;

public class RebalanceUtilEx {
    public static CompletableFuture<Void> startPeerRemoval(TablePartitionId partId, Assignment peerAssignment, MetaStorageManager metaStorageMgr, long assignmentsTimestamp) {
        ByteArray key = RebalanceUtil.switchReduceKey(partId);
        return ((CompletableFuture)metaStorageMgr.get(key).thenCompose(retrievedAssignmentsSwitchReduce -> {
            byte[] prevValue = retrievedAssignmentsSwitchReduce.value();
            if (prevValue != null) {
                Assignments prev = Assignments.fromBytes(prevValue);
                prev.add(peerAssignment);
                return metaStorageMgr.invoke((Condition)Conditions.revision(key).eq(retrievedAssignmentsSwitchReduce.revision()), Operations.put(key, prev.toBytes()), Operations.noop());
            }
            Assignments newValue = Assignments.of(new HashSet<Assignment>(), assignmentsTimestamp);
            newValue.add(peerAssignment);
            return metaStorageMgr.invoke((Condition)Conditions.notExists(key), Operations.put(key, newValue.toBytes()), Operations.noop());
        })).thenCompose(res -> {
            if (!res.booleanValue()) {
                return RebalanceUtilEx.startPeerRemoval(partId, peerAssignment, metaStorageMgr, assignmentsTimestamp);
            }
            return CompletableFutures.nullCompletedFuture();
        });
    }

    public static CompletableFuture<Void> handleReduceChanged(MetaStorageManager metaStorageMgr, Collection<String> dataNodes, int partitions, int replicas, int consensusGroupSize, TablePartitionId partId, WatchEvent event, long assignmentsTimestamp) {
        Entry entry = event.entryEvent().newEntry();
        byte[] eventData = entry.value();
        assert (eventData != null) : "Null event data for " + partId;
        Assignments switchReduce = Assignments.fromBytes(eventData);
        if (switchReduce.isEmpty()) {
            return CompletableFutures.nullCompletedFuture();
        }
        Set<Assignment> assignments = PartitionDistributionUtils.calculateAssignmentForPartition(dataNodes, partId.partitionId(), partitions, replicas, consensusGroupSize);
        ByteArray pendingKey = RebalanceUtil.pendingPartAssignmentsQueueKey(partId);
        Set<Assignment> pendingAssignments = CollectionUtils.difference(assignments, switchReduce.nodes());
        byte[] pendingByteArray = AssignmentsQueue.toBytes(Assignments.of(pendingAssignments, assignmentsTimestamp));
        byte[] assignmentsByteArray = Assignments.toBytes(assignments, assignmentsTimestamp);
        ByteArray changeTriggerKey = RebalanceUtil.pendingChangeTriggerKey(partId);
        byte[] timestamp = ByteUtils.longToBytesKeepingOrder(entry.timestamp().longValue());
        CompoundCondition revisionAndTimestampDontExistOrLessThan = Conditions.or(Conditions.notExists(changeTriggerKey), Conditions.value(changeTriggerKey).lt(timestamp));
        Iif resultingOperation = Statements.iif((Condition)Conditions.and(revisionAndTimestampDontExistOrLessThan, Conditions.and(Conditions.notExists(pendingKey), Conditions.notExists(RebalanceUtil.stablePartAssignmentsKey(partId)))), Operations.ops(Operations.put(pendingKey, pendingByteArray), Operations.put(RebalanceUtil.stablePartAssignmentsKey(partId), assignmentsByteArray), Operations.put(changeTriggerKey, timestamp)).yield(), Statements.iif((Condition)Conditions.and(revisionAndTimestampDontExistOrLessThan, Conditions.notExists(pendingKey)), Operations.ops(Operations.put(pendingKey, pendingByteArray), Operations.put(changeTriggerKey, timestamp)).yield(), Operations.ops(new Operation[0]).yield()));
        return metaStorageMgr.invoke(resultingOperation).thenApply(unused -> null);
    }
}

