/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.util;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class HashUtils {
    private static final long C1 = -8663945395140668459L;
    private static final long C2 = 5545529020109919103L;
    private static final int R1 = 31;
    private static final int R2 = 27;
    private static final int R3 = 33;
    private static final int M = 5;
    private static final int N1 = 1390208809;
    private static final int N2 = 944331445;

    private HashUtils() {
    }

    public static int hash32(byte[] data) {
        long hash = HashUtils.hash64(data);
        return (int)(hash ^ hash >>> 32);
    }

    public static int hash32(ByteBuffer data) {
        long hash = HashUtils.hash64(data);
        return (int)(hash ^ hash >>> 32);
    }

    public static int hash32(byte data) {
        long hash = HashUtils.hash64(data, 0L);
        return (int)(hash ^ hash >>> 32);
    }

    public static int hash32(short data) {
        long hash = HashUtils.hash64(data, 0L);
        return (int)(hash ^ hash >>> 32);
    }

    public static int hash32(int data) {
        return HashUtils.hash32(data, 0);
    }

    public static int hash32(int data, int seed) {
        long hash = HashUtils.hash64(data, (long)seed);
        return (int)(hash ^ hash >>> 32);
    }

    public static int hash32(long data) {
        return HashUtils.hash32(data, 0);
    }

    public static int hash32(long data, int seed) {
        long hash = HashUtils.hash64(data, (long)seed);
        return (int)(hash ^ hash >>> 32);
    }

    public static int combine(int hash1, int hash2) {
        return HashUtils.hash32(hash1, hash2);
    }

    public static long hash64(byte data, long seed) {
        return HashUtils.hashInternal(data, seed);
    }

    public static long hash64(short data, long seed) {
        return HashUtils.hashInternal(data, seed);
    }

    public static long hash64(int data, long seed) {
        return HashUtils.hashInternal(data, seed);
    }

    public static long hash64(long data, long seed) {
        return HashUtils.hashInternal(data, seed);
    }

    public static long hash64(byte[] data) {
        return HashUtils.hash64(data, 0, data.length, 0);
    }

    public static long hash64(ByteBuffer data) {
        return HashUtils.hash64(data, 0, data.remaining(), 0);
    }

    public static long hash64(byte[] data, int offset, int length, int seed) {
        return HashUtils.hashInternal(data, offset, length, (long)seed & 0xFFFFFFFFL);
    }

    public static long hash64(ByteBuffer data, int offset, int length, int seed) {
        return HashUtils.hashInternal(data, offset, length, (long)seed & 0xFFFFFFFFL);
    }

    private static long hashInternal(byte data, long seed) {
        long h1 = seed;
        long h2 = seed;
        long k1 = 0L;
        k1 ^= (long)data & 0xFFL;
        k1 *= -8663945395140668459L;
        k1 = Long.rotateLeft(k1, 31);
        h1 ^= (k1 *= 5545529020109919103L);
        h1 ^= 1L;
        h1 += (h2 ^= 1L);
        h2 += h1;
        h1 = HashUtils.fmix64(h1);
        h2 = HashUtils.fmix64(h2);
        return h1 + h2;
    }

    private static long hashInternal(short data, long seed) {
        long h1 = seed;
        long h2 = seed;
        long k1 = 0L;
        k1 ^= (long)data & 0xFFFFL;
        k1 *= -8663945395140668459L;
        k1 = Long.rotateLeft(k1, 31);
        h1 ^= (k1 *= 5545529020109919103L);
        h1 ^= 2L;
        h1 += (h2 ^= 2L);
        h2 += h1;
        h1 = HashUtils.fmix64(h1);
        h2 = HashUtils.fmix64(h2);
        return h1 + h2;
    }

    private static long hashInternal(int data, long seed) {
        long h1 = seed;
        long h2 = seed;
        long k1 = 0L;
        k1 ^= (long)data & 0xFFFFFFFFL;
        k1 *= -8663945395140668459L;
        k1 = Long.rotateLeft(k1, 31);
        h1 ^= (k1 *= 5545529020109919103L);
        h1 ^= 4L;
        h1 += (h2 ^= 4L);
        h2 += h1;
        h1 = HashUtils.fmix64(h1);
        h2 = HashUtils.fmix64(h2);
        return h1 + h2;
    }

    private static long hashInternal(long data, long seed) {
        long h1 = seed;
        long h2 = seed;
        long k1 = 0L;
        k1 ^= data;
        k1 *= -8663945395140668459L;
        k1 = Long.rotateLeft(k1, 31);
        h1 ^= (k1 *= 5545529020109919103L);
        h1 ^= 8L;
        h1 += (h2 ^= 8L);
        h2 += h1;
        h1 = HashUtils.fmix64(h1);
        h2 = HashUtils.fmix64(h2);
        return h1 + h2;
    }

    private static long hashInternal(byte[] data, int offset, int length, long seed) {
        long h1 = seed;
        long h2 = seed;
        int nblocks = length >> 4;
        for (int i = 0; i < nblocks; ++i) {
            int index = offset + (i << 4);
            long k1 = HashUtils.getLittleEndianLong(data, index);
            long k2 = HashUtils.getLittleEndianLong(data, index + 8);
            k1 *= -8663945395140668459L;
            k1 = Long.rotateLeft(k1, 31);
            h1 ^= (k1 *= 5545529020109919103L);
            h1 = Long.rotateLeft(h1, 27);
            h1 += h2;
            h1 = h1 * 5L + 1390208809L;
            k2 *= 5545529020109919103L;
            k2 = Long.rotateLeft(k2, 33);
            h2 ^= (k2 *= -8663945395140668459L);
            h2 = Long.rotateLeft(h2, 31);
            h2 += h1;
            h2 = h2 * 5L + 944331445L;
        }
        long k1 = 0L;
        long k2 = 0L;
        int index = offset + (nblocks << 4);
        switch (offset + length - index) {
            case 15: {
                k2 ^= ((long)data[index + 14] & 0xFFL) << 48;
            }
            case 14: {
                k2 ^= ((long)data[index + 13] & 0xFFL) << 40;
            }
            case 13: {
                k2 ^= ((long)data[index + 12] & 0xFFL) << 32;
            }
            case 12: {
                k2 ^= ((long)data[index + 11] & 0xFFL) << 24;
            }
            case 11: {
                k2 ^= ((long)data[index + 10] & 0xFFL) << 16;
            }
            case 10: {
                k2 ^= ((long)data[index + 9] & 0xFFL) << 8;
            }
            case 9: {
                k2 ^= (long)(data[index + 8] & 0xFF);
                k2 *= 5545529020109919103L;
                k2 = Long.rotateLeft(k2, 33);
                h2 ^= (k2 *= -8663945395140668459L);
            }
            case 8: {
                k1 ^= ((long)data[index + 7] & 0xFFL) << 56;
            }
            case 7: {
                k1 ^= ((long)data[index + 6] & 0xFFL) << 48;
            }
            case 6: {
                k1 ^= ((long)data[index + 5] & 0xFFL) << 40;
            }
            case 5: {
                k1 ^= ((long)data[index + 4] & 0xFFL) << 32;
            }
            case 4: {
                k1 ^= ((long)data[index + 3] & 0xFFL) << 24;
            }
            case 3: {
                k1 ^= ((long)data[index + 2] & 0xFFL) << 16;
            }
            case 2: {
                k1 ^= ((long)data[index + 1] & 0xFFL) << 8;
            }
            case 1: {
                k1 ^= (long)(data[index] & 0xFF);
                k1 *= -8663945395140668459L;
                k1 = Long.rotateLeft(k1, 31);
                h1 ^= (k1 *= 5545529020109919103L);
            }
        }
        h1 ^= (long)length;
        h1 += (h2 ^= (long)length);
        h2 += h1;
        h1 = HashUtils.fmix64(h1);
        h2 = HashUtils.fmix64(h2);
        return h1 + h2;
    }

    private static long hashInternal(ByteBuffer data, int offset, int length, long seed) {
        long h1 = seed;
        long h2 = seed;
        int nblocks = length >> 4;
        ByteOrder prevOrder = data.order();
        data.order(ByteOrder.LITTLE_ENDIAN);
        for (int i = 0; i < nblocks; ++i) {
            int index = offset + (i << 4);
            long k1 = data.getLong(index);
            long k2 = data.getLong(index + 8);
            k1 *= -8663945395140668459L;
            k1 = Long.rotateLeft(k1, 31);
            h1 ^= (k1 *= 5545529020109919103L);
            h1 = Long.rotateLeft(h1, 27);
            h1 += h2;
            h1 = h1 * 5L + 1390208809L;
            k2 *= 5545529020109919103L;
            k2 = Long.rotateLeft(k2, 33);
            h2 ^= (k2 *= -8663945395140668459L);
            h2 = Long.rotateLeft(h2, 31);
            h2 += h1;
            h2 = h2 * 5L + 944331445L;
        }
        data.order(prevOrder);
        long k1 = 0L;
        long k2 = 0L;
        int index = offset + (nblocks << 4);
        switch (offset + length - index) {
            case 15: {
                k2 ^= ((long)data.get(index + 14) & 0xFFL) << 48;
            }
            case 14: {
                k2 ^= ((long)data.get(index + 13) & 0xFFL) << 40;
            }
            case 13: {
                k2 ^= ((long)data.get(index + 12) & 0xFFL) << 32;
            }
            case 12: {
                k2 ^= ((long)data.get(index + 11) & 0xFFL) << 24;
            }
            case 11: {
                k2 ^= ((long)data.get(index + 10) & 0xFFL) << 16;
            }
            case 10: {
                k2 ^= ((long)data.get(index + 9) & 0xFFL) << 8;
            }
            case 9: {
                k2 ^= (long)(data.get(index + 8) & 0xFF);
                k2 *= 5545529020109919103L;
                k2 = Long.rotateLeft(k2, 33);
                h2 ^= (k2 *= -8663945395140668459L);
            }
            case 8: {
                k1 ^= ((long)data.get(index + 7) & 0xFFL) << 56;
            }
            case 7: {
                k1 ^= ((long)data.get(index + 6) & 0xFFL) << 48;
            }
            case 6: {
                k1 ^= ((long)data.get(index + 5) & 0xFFL) << 40;
            }
            case 5: {
                k1 ^= ((long)data.get(index + 4) & 0xFFL) << 32;
            }
            case 4: {
                k1 ^= ((long)data.get(index + 3) & 0xFFL) << 24;
            }
            case 3: {
                k1 ^= ((long)data.get(index + 2) & 0xFFL) << 16;
            }
            case 2: {
                k1 ^= ((long)data.get(index + 1) & 0xFFL) << 8;
            }
            case 1: {
                k1 ^= (long)(data.get(index) & 0xFF);
                k1 *= -8663945395140668459L;
                k1 = Long.rotateLeft(k1, 31);
                h1 ^= (k1 *= 5545529020109919103L);
            }
        }
        h1 ^= (long)length;
        h1 += (h2 ^= (long)length);
        h2 += h1;
        h1 = HashUtils.fmix64(h1);
        h2 = HashUtils.fmix64(h2);
        return h1 + h2;
    }

    private static long getLittleEndianLong(byte[] data, int index) {
        return (long)data[index] & 0xFFL | ((long)data[index + 1] & 0xFFL) << 8 | ((long)data[index + 2] & 0xFFL) << 16 | ((long)data[index + 3] & 0xFFL) << 24 | ((long)data[index + 4] & 0xFFL) << 32 | ((long)data[index + 5] & 0xFFL) << 40 | ((long)data[index + 6] & 0xFFL) << 48 | ((long)data[index + 7] & 0xFFL) << 56;
    }

    private static long fmix64(long hash) {
        hash ^= hash >>> 33;
        hash *= -49064778989728563L;
        hash ^= hash >>> 33;
        hash *= -4265267296055464877L;
        hash ^= hash >>> 33;
        return hash;
    }
}

