/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.table.distributed.schema;

import java.nio.ByteBuffer;
import org.apache.ignite3.internal.catalog.CatalogService;
import org.apache.ignite3.internal.logger.IgniteLogger;
import org.apache.ignite3.internal.logger.Loggers;
import org.apache.ignite3.internal.raft.Loza;
import org.apache.ignite3.internal.raft.Marshaller;
import org.apache.ignite3.internal.raft.util.OptimizedMarshaller;
import org.apache.ignite3.internal.table.distributed.schema.CatalogVersionSufficiency;
import org.apache.ignite3.internal.table.distributed.schema.PartitionCommandsMarshaller;
import org.apache.ignite3.raft.jraft.Node;
import org.apache.ignite3.raft.jraft.Status;
import org.apache.ignite3.raft.jraft.core.NodeImpl;
import org.apache.ignite3.raft.jraft.core.State;
import org.apache.ignite3.raft.jraft.entity.PeerId;
import org.apache.ignite3.raft.jraft.error.RaftError;
import org.apache.ignite3.raft.jraft.rpc.ActionRequest;
import org.apache.ignite3.raft.jraft.rpc.Message;
import org.apache.ignite3.raft.jraft.rpc.RaftRpcFactory;
import org.apache.ignite3.raft.jraft.rpc.RpcContext;
import org.apache.ignite3.raft.jraft.rpc.WriteActionRequest;
import org.apache.ignite3.raft.jraft.rpc.impl.ActionRequestInterceptor;
import org.jetbrains.annotations.Nullable;

public class CheckCatalogVersionOnActionRequest
implements ActionRequestInterceptor {
    private static final IgniteLogger LOG = Loggers.forClass(CheckCatalogVersionOnActionRequest.class);
    private final CatalogService catalogService;

    public CheckCatalogVersionOnActionRequest(CatalogService catalogService) {
        this.catalogService = catalogService;
    }

    @Override
    @Nullable
    public Message intercept(RpcContext rpcCtx, ActionRequest request, Marshaller commandsMarshaller) {
        Node node = rpcCtx.getNodeManager().get(request.groupId(), new PeerId(rpcCtx.getLocalConsistentId()));
        if (node == null) {
            return Loza.FACTORY.errorResponse().errorCode(RaftError.UNKNOWN.getNumber()).build();
        }
        Message errorIfNotLeader = CheckCatalogVersionOnActionRequest.errorResponseIfNotLeader(node);
        if (errorIfNotLeader != null) {
            return errorIfNotLeader;
        }
        if (!(commandsMarshaller instanceof PartitionCommandsMarshaller)) {
            return null;
        }
        if (!(request instanceof WriteActionRequest)) {
            return null;
        }
        PartitionCommandsMarshaller partitionCommandsMarshaller = (PartitionCommandsMarshaller)commandsMarshaller;
        byte[] command = ((WriteActionRequest)request).command();
        int requiredCatalogVersion = partitionCommandsMarshaller.readRequiredCatalogVersion(ByteBuffer.wrap(command).order(OptimizedMarshaller.ORDER));
        if (requiredCatalogVersion >= 0 && !CatalogVersionSufficiency.isMetadataAvailableFor(requiredCatalogVersion, this.catalogService)) {
            LOG.warn("Metadata not yet available, rejecting ActionRequest with EBUSY [group={}, requiredLevel={}].", request.groupId(), requiredCatalogVersion);
            return RaftRpcFactory.DEFAULT.newResponse(node.getRaftOptions().getRaftMessagesFactory(), RaftError.EBUSY, "Metadata not yet available, rejecting ActionRequest with EBUSY [group=%s, requiredLevel=%d].", request.groupId(), requiredCatalogVersion);
        }
        return null;
    }

    @Nullable
    private static Message errorResponseIfNotLeader(Node node) {
        State state = node.getNodeState();
        if (state == State.STATE_LEADER) {
            return null;
        }
        Status st = NodeImpl.cannotApplyBecauseNotLeaderStatus(state);
        LOG.debug("Node {} can't apply, status={}.", node.getNodeId(), st);
        PeerId leaderId = node.getLeaderId();
        boolean returnLeaderId = st.getRaftError() == RaftError.EPERM && leaderId != null;
        return RaftRpcFactory.DEFAULT.newResponse(returnLeaderId ? leaderId.toString() : null, node.getRaftOptions().getRaftMessagesFactory(), st.getRaftError(), st.getErrorMsg(), new Object[0]);
    }
}

