/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.sql.metrics;

import java.util.List;
import org.apache.ignite3.internal.metrics.AbstractMetricSource;
import org.apache.ignite3.internal.metrics.AtomicLongMetric;
import org.apache.ignite3.internal.metrics.Metric;
import org.apache.ignite3.internal.sql.engine.util.cache.StatsCounter;

public class SqlPlanCacheMetricSource
extends AbstractMetricSource<Holder>
implements StatsCounter {
    public static final String NAME = "sql.plan.cache";

    public SqlPlanCacheMetricSource() {
        super(NAME);
    }

    @Override
    public void recordHits(int count) {
        Holder h = (Holder)this.holder();
        if (h != null) {
            h.cachePlanHits.add(count);
        }
    }

    @Override
    public void recordMisses(int count) {
        Holder h = (Holder)this.holder();
        if (h != null) {
            h.cachePlanMisses.add(count);
        }
    }

    @Override
    protected Holder createHolder() {
        return new Holder();
    }

    protected static class Holder
    implements AbstractMetricSource.Holder<Holder> {
        private final AtomicLongMetric cachePlanHits = new AtomicLongMetric("Hits", "Cache plan hits");
        private final AtomicLongMetric cachePlanMisses = new AtomicLongMetric("Misses", "Cache plan misses");

        protected Holder() {
        }

        @Override
        public Iterable<Metric> metrics() {
            return List.of(this.cachePlanHits, this.cachePlanMisses);
        }
    }
}

