/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.sql.engine.util;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.util.ImmutableIntList;
import org.apache.ignite3.internal.sql.engine.schema.ColumnDescriptor;
import org.apache.ignite3.internal.sql.engine.schema.TableDescriptor;
import org.apache.ignite3.internal.sql.engine.type.IgniteTypeFactory;
import org.jetbrains.annotations.Nullable;

public final class RowTypeUtils {
    public static RelDataType rowType(TableDescriptor tableDescriptor, IgniteTypeFactory factory) {
        return tableDescriptor.rowType(factory, RowTypeUtils.storedColumns(tableDescriptor));
    }

    public static int storedColumnsCount(TableDescriptor tableDescriptor) {
        int count = 0;
        for (ColumnDescriptor descriptor : tableDescriptor) {
            count += descriptor.virtual() ? 0 : 1;
        }
        return count;
    }

    @Nullable
    private static ImmutableIntList storedColumns(TableDescriptor tableDescriptor) {
        if (!tableDescriptor.hasVirtualColumns()) {
            return null;
        }
        IntArrayList storedColumns = new IntArrayList(tableDescriptor.columnsCount());
        for (ColumnDescriptor descriptor : tableDescriptor) {
            if (descriptor.virtual()) continue;
            storedColumns.add(descriptor.logicalIndex());
        }
        return ImmutableIntList.of((int[])storedColumns.toIntArray());
    }
}

